@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [SnapshotPolicy].
 */
@PulumiTagMarker
public class SnapshotPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnapshotPolicyArgs = SnapshotPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnapshotPolicyArgsBuilder.() -> Unit) {
        val builder = SnapshotPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SnapshotPolicy {
        val builtJavaResource = com.pulumi.alicloud.ecs.SnapshotPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SnapshotPolicy(builtJavaResource)
    }
}

/**
 * > **DEPRECATED:** This resource has been renamed to alicloud.ecs.AutoSnapshotPolicy from version 1.117.0.
 * Provides an ECS snapshot policy resource.
 * For information about snapshot policy and how to use it, see [Snapshot](https://www.alibabacloud.com/help/doc-detail/25460.html).
 * > **NOTE:** Available in 1.42.0+.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const sp = new alicloud.ecs.SnapshotPolicy("sp", {
 *     name: "tf-testAcc-sp",
 *     repeatWeekdays: [
 *         "1",
 *         "2",
 *         "3",
 *     ],
 *     retentionDays: -1,
 *     timePoints: [
 *         "1",
 *         "22",
 *         "23",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * sp = alicloud.ecs.SnapshotPolicy("sp",
 *     name="tf-testAcc-sp",
 *     repeat_weekdays=[
 *         "1",
 *         "2",
 *         "3",
 *     ],
 *     retention_days=-1,
 *     time_points=[
 *         "1",
 *         "22",
 *         "23",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sp = new AliCloud.Ecs.SnapshotPolicy("sp", new()
 *     {
 *         Name = "tf-testAcc-sp",
 *         RepeatWeekdays = new[]
 *         {
 *             "1",
 *             "2",
 *             "3",
 *         },
 *         RetentionDays = -1,
 *         TimePoints = new[]
 *         {
 *             "1",
 *             "22",
 *             "23",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewSnapshotPolicy(ctx, "sp", &ecs.SnapshotPolicyArgs{
 * 			Name: pulumi.String("tf-testAcc-sp"),
 * 			RepeatWeekdays: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("2"),
 * 				pulumi.String("3"),
 * 			},
 * 			RetentionDays: int(-1),
 * 			TimePoints: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("22"),
 * 				pulumi.String("23"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * resources:
 *   sp:
 *     type: alicloud:ecs:SnapshotPolicy
 *     properties:
 *       name: tf-testAcc-sp
 *       repeatWeekdays:
 *         - '1'
 *         - '2'
 *         - '3'
 *       retentionDays: -1
 *       timePoints:
 *         - '1'
 *         - '22'
 *         - '23'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Snapshot can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/snapshotPolicy:SnapshotPolicy snapshot sp-abc1234567890000
 * ```
 */
public class SnapshotPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.SnapshotPolicy,
) : KotlinCustomResource(javaResource, SnapshotPolicyMapper) {
    public val copiedSnapshotsRetentionDays: Output<Int>?
        get() = javaResource.copiedSnapshotsRetentionDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val enableCrossRegionCopy: Output<Boolean>?
        get() = javaResource.enableCrossRegionCopy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The snapshot policy name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
     * - A maximum of seven time points can be selected.
     * - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
     */
    public val repeatWeekdays: Output<List<String>>
        get() = javaResource.repeatWeekdays().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The snapshot retention time, and the unit of measurement is day. Optional values:
     * - -1: The automatic snapshots are retained permanently.
     * - [1, 65536]: The number of days retained.
     * Default value: -1.
     */
    public val retentionDays: Output<Int>
        get() = javaResource.retentionDays().applyValue({ args0 -> args0 })

    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    public val targetCopyRegions: Output<List<String>>?
        get() = javaResource.targetCopyRegions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
     * - A maximum of 24 time points can be selected.
     * - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
     */
    public val timePoints: Output<List<String>>
        get() = javaResource.timePoints().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object SnapshotPolicyMapper : ResourceMapper<SnapshotPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.SnapshotPolicy::class == javaResource::class

    override fun map(javaResource: Resource): SnapshotPolicy = SnapshotPolicy(
        javaResource as
            com.pulumi.alicloud.ecs.SnapshotPolicy,
    )
}

/**
 * @see [SnapshotPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SnapshotPolicy].
 */
public suspend fun snapshotPolicy(
    name: String,
    block: suspend SnapshotPolicyResourceBuilder.() -> Unit,
): SnapshotPolicy {
    val builder = SnapshotPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SnapshotPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snapshotPolicy(name: String): SnapshotPolicy {
    val builder = SnapshotPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
