@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.SnapshotPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * > **DEPRECATED:** This resource has been renamed to alicloud.ecs.AutoSnapshotPolicy from version 1.117.0.
 * Provides an ECS snapshot policy resource.
 * For information about snapshot policy and how to use it, see [Snapshot](https://www.alibabacloud.com/help/doc-detail/25460.html).
 * > **NOTE:** Available in 1.42.0+.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const sp = new alicloud.ecs.SnapshotPolicy("sp", {
 *     name: "tf-testAcc-sp",
 *     repeatWeekdays: [
 *         "1",
 *         "2",
 *         "3",
 *     ],
 *     retentionDays: -1,
 *     timePoints: [
 *         "1",
 *         "22",
 *         "23",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * sp = alicloud.ecs.SnapshotPolicy("sp",
 *     name="tf-testAcc-sp",
 *     repeat_weekdays=[
 *         "1",
 *         "2",
 *         "3",
 *     ],
 *     retention_days=-1,
 *     time_points=[
 *         "1",
 *         "22",
 *         "23",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sp = new AliCloud.Ecs.SnapshotPolicy("sp", new()
 *     {
 *         Name = "tf-testAcc-sp",
 *         RepeatWeekdays = new[]
 *         {
 *             "1",
 *             "2",
 *             "3",
 *         },
 *         RetentionDays = -1,
 *         TimePoints = new[]
 *         {
 *             "1",
 *             "22",
 *             "23",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewSnapshotPolicy(ctx, "sp", &ecs.SnapshotPolicyArgs{
 * 			Name: pulumi.String("tf-testAcc-sp"),
 * 			RepeatWeekdays: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("2"),
 * 				pulumi.String("3"),
 * 			},
 * 			RetentionDays: int(-1),
 * 			TimePoints: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("22"),
 * 				pulumi.String("23"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * resources:
 *   sp:
 *     type: alicloud:ecs:SnapshotPolicy
 *     properties:
 *       name: tf-testAcc-sp
 *       repeatWeekdays:
 *         - '1'
 *         - '2'
 *         - '3'
 *       retentionDays: -1
 *       timePoints:
 *         - '1'
 *         - '22'
 *         - '23'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Snapshot can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/snapshotPolicy:SnapshotPolicy snapshot sp-abc1234567890000
 * ```
 * @property copiedSnapshotsRetentionDays
 * @property enableCrossRegionCopy
 * @property name The snapshot policy name.
 * @property repeatWeekdays The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
 * - A maximum of seven time points can be selected.
 * - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
 * @property retentionDays The snapshot retention time, and the unit of measurement is day. Optional values:
 * - -1: The automatic snapshots are retained permanently.
 * - [1, 65536]: The number of days retained.
 * Default value: -1.
 * @property tags
 * @property targetCopyRegions
 * @property timePoints The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
 * - A maximum of 24 time points can be selected.
 * - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
 */
public data class SnapshotPolicyArgs(
    public val copiedSnapshotsRetentionDays: Output<Int>? = null,
    public val enableCrossRegionCopy: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val repeatWeekdays: Output<List<String>>? = null,
    public val retentionDays: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetCopyRegions: Output<List<String>>? = null,
    public val timePoints: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.SnapshotPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.SnapshotPolicyArgs =
        com.pulumi.alicloud.ecs.SnapshotPolicyArgs.builder()
            .copiedSnapshotsRetentionDays(copiedSnapshotsRetentionDays?.applyValue({ args0 -> args0 }))
            .enableCrossRegionCopy(enableCrossRegionCopy?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .repeatWeekdays(repeatWeekdays?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .retentionDays(retentionDays?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetCopyRegions(targetCopyRegions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .timePoints(timePoints?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SnapshotPolicyArgs].
 */
@PulumiTagMarker
public class SnapshotPolicyArgsBuilder internal constructor() {
    private var copiedSnapshotsRetentionDays: Output<Int>? = null

    private var enableCrossRegionCopy: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var repeatWeekdays: Output<List<String>>? = null

    private var retentionDays: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetCopyRegions: Output<List<String>>? = null

    private var timePoints: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("exutkqudqycemxex")
    public suspend fun copiedSnapshotsRetentionDays(`value`: Output<Int>) {
        this.copiedSnapshotsRetentionDays = value
    }

    /**
     * @param value
     */
    @JvmName("geuyscuiqpmtobqx")
    public suspend fun enableCrossRegionCopy(`value`: Output<Boolean>) {
        this.enableCrossRegionCopy = value
    }

    /**
     * @param value The snapshot policy name.
     */
    @JvmName("dnvitrucgemxdhus")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
     * - A maximum of seven time points can be selected.
     * - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
     */
    @JvmName("pgplolqdlvsudxbv")
    public suspend fun repeatWeekdays(`value`: Output<List<String>>) {
        this.repeatWeekdays = value
    }

    @JvmName("yddvvylwabohxsks")
    public suspend fun repeatWeekdays(vararg values: Output<String>) {
        this.repeatWeekdays = Output.all(values.asList())
    }

    /**
     * @param values The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
     * - A maximum of seven time points can be selected.
     * - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
     */
    @JvmName("nhyjmqeoatiyahyb")
    public suspend fun repeatWeekdays(values: List<Output<String>>) {
        this.repeatWeekdays = Output.all(values)
    }

    /**
     * @param value The snapshot retention time, and the unit of measurement is day. Optional values:
     * - -1: The automatic snapshots are retained permanently.
     * - [1, 65536]: The number of days retained.
     * Default value: -1.
     */
    @JvmName("ulhtugnukeueroup")
    public suspend fun retentionDays(`value`: Output<Int>) {
        this.retentionDays = value
    }

    /**
     * @param value
     */
    @JvmName("ahsfnhowfvstlrtv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("saryyvrfivydocgl")
    public suspend fun targetCopyRegions(`value`: Output<List<String>>) {
        this.targetCopyRegions = value
    }

    @JvmName("liiiypygghqudwnh")
    public suspend fun targetCopyRegions(vararg values: Output<String>) {
        this.targetCopyRegions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ferhmgdpkewmovfl")
    public suspend fun targetCopyRegions(values: List<Output<String>>) {
        this.targetCopyRegions = Output.all(values)
    }

    /**
     * @param value The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
     * - A maximum of 24 time points can be selected.
     * - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
     */
    @JvmName("hiyedajgtgdtjddq")
    public suspend fun timePoints(`value`: Output<List<String>>) {
        this.timePoints = value
    }

    @JvmName("cbhyflrvuawgdvws")
    public suspend fun timePoints(vararg values: Output<String>) {
        this.timePoints = Output.all(values.asList())
    }

    /**
     * @param values The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
     * - A maximum of 24 time points can be selected.
     * - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
     */
    @JvmName("aewxkcryreregcji")
    public suspend fun timePoints(values: List<Output<String>>) {
        this.timePoints = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("udydvlgfgwvwnlms")
    public suspend fun copiedSnapshotsRetentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copiedSnapshotsRetentionDays = mapped
    }

    /**
     * @param value
     */
    @JvmName("lpnyenhclceymvuu")
    public suspend fun enableCrossRegionCopy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCrossRegionCopy = mapped
    }

    /**
     * @param value The snapshot policy name.
     */
    @JvmName("pgwtbiloxsmgtlil")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
     * - A maximum of seven time points can be selected.
     * - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
     */
    @JvmName("uyxnkjjfmasoksph")
    public suspend fun repeatWeekdays(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repeatWeekdays = mapped
    }

    /**
     * @param values The automatic snapshot repetition dates. The unit of measurement is day and the repeating cycle is a week. Value range: [1, 7], which represents days starting from Monday to Sunday, for example 1  indicates Monday. When you want to schedule multiple automatic snapshot tasks for a disk in a week, you can set the RepeatWeekdays to an array.
     * - A maximum of seven time points can be selected.
     * - The format is  an JSON array of ["1", "2", … "7"]  and the time points are separated by commas (,).
     */
    @JvmName("uacrdtjsgtqcjkxs")
    public suspend fun repeatWeekdays(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repeatWeekdays = mapped
    }

    /**
     * @param value The snapshot retention time, and the unit of measurement is day. Optional values:
     * - -1: The automatic snapshots are retained permanently.
     * - [1, 65536]: The number of days retained.
     * Default value: -1.
     */
    @JvmName("tahuyaqxkfdbduru")
    public suspend fun retentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDays = mapped
    }

    /**
     * @param value
     */
    @JvmName("fimljljmtbsdegnw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("uxabigxlwhdmfrll")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("wjxttphcglfvlugs")
    public suspend fun targetCopyRegions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetCopyRegions = mapped
    }

    /**
     * @param values
     */
    @JvmName("hrsvgkvuevmajnes")
    public suspend fun targetCopyRegions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetCopyRegions = mapped
    }

    /**
     * @param value The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
     * - A maximum of 24 time points can be selected.
     * - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
     */
    @JvmName("ylnypigxkthnexss")
    public suspend fun timePoints(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timePoints = mapped
    }

    /**
     * @param values The automatic snapshot creation schedule, and the unit of measurement is hour. Value range: [0, 23], which represents from 00:00 to 24:00,  for example 1 indicates 01:00. When you want to schedule multiple automatic snapshot tasks for a disk in a day, you can set the TimePoints to an array.
     * - A maximum of 24 time points can be selected.
     * - The format is  an JSON array of ["0", "1", … "23"] and the time points are separated by commas (,).
     */
    @JvmName("cslcojlmyvmignxm")
    public suspend fun timePoints(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timePoints = mapped
    }

    internal fun build(): SnapshotPolicyArgs = SnapshotPolicyArgs(
        copiedSnapshotsRetentionDays = copiedSnapshotsRetentionDays,
        enableCrossRegionCopy = enableCrossRegionCopy,
        name = name,
        repeatWeekdays = repeatWeekdays,
        retentionDays = retentionDays,
        tags = tags,
        targetCopyRegions = targetCopyRegions,
        timePoints = timePoints,
    )
}
