@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [StorageCapacityUnit].
 */
@PulumiTagMarker
public class StorageCapacityUnitResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StorageCapacityUnitArgs = StorageCapacityUnitArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StorageCapacityUnitArgsBuilder.() -> Unit) {
        val builder = StorageCapacityUnitArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StorageCapacityUnit {
        val builtJavaResource = com.pulumi.alicloud.ecs.StorageCapacityUnit(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StorageCapacityUnit(builtJavaResource)
    }
}

/**
 * Provides a ECS Storage Capacity Unit resource.
 * For information about ECS Storage Capacity Unit and how to use it, see [What is Storage Capacity Unit](https://www.alibabacloud.com/help/en/doc-detail/161157.html).
 * > **NOTE:** Available in v1.155.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ecs.StorageCapacityUnit("default", {
 *     capacity: 20,
 *     description: "tftestdescription",
 *     storageCapacityUnitName: "tftestname",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ecs.StorageCapacityUnit("default",
 *     capacity=20,
 *     description="tftestdescription",
 *     storage_capacity_unit_name="tftestname")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ecs.StorageCapacityUnit("default", new()
 *     {
 *         Capacity = 20,
 *         Description = "tftestdescription",
 *         StorageCapacityUnitName = "tftestname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewStorageCapacityUnit(ctx, "default", &ecs.StorageCapacityUnitArgs{
 * 			Capacity:                pulumi.Int(20),
 * 			Description:             pulumi.String("tftestdescription"),
 * 			StorageCapacityUnitName: pulumi.String("tftestname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.StorageCapacityUnit;
 * import com.pulumi.alicloud.ecs.StorageCapacityUnitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new StorageCapacityUnit("default", StorageCapacityUnitArgs.builder()
 *             .capacity(20)
 *             .description("tftestdescription")
 *             .storageCapacityUnitName("tftestname")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ecs:StorageCapacityUnit
 *     properties:
 *       capacity: 20
 *       description: tftestdescription
 *       storageCapacityUnitName: tftestname
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Storage Capacity Unit can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/storageCapacityUnit:StorageCapacityUnit example <id>
 * ```
 */
public class StorageCapacityUnit internal constructor(
    override val javaResource: com.pulumi.alicloud.ecs.StorageCapacityUnit,
) : KotlinCustomResource(javaResource, StorageCapacityUnitMapper) {
    /**
     * The capacity of the Storage Capacity Unit. Unit: GiB. Valid values: `20`, `40`, `100`, `200`, `500`, `1024`, `2048`, `5120`, `10240`, `20480`, and `51200`.
     */
    public val capacity: Output<Int>
        get() = javaResource.capacity().applyValue({ args0 -> args0 })

    /**
     * The description of the Storage Capacity Unit. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The validity period of the Storage Capacity Unit. Default value: `1`.
     * * When PeriodUnit is set to Month, Valid values: `1`, `2`, `3`, `6`.
     * * When PeriodUnit is set to Year, Valid values: `1`, `3`, `5`.
     */
    public val period: Output<Int>
        get() = javaResource.period().applyValue({ args0 -> args0 })

    /**
     * The unit of the validity period of the Storage Capacity Unit. Default value: `Month`. Valid values: `Month`, `Year`.
     */
    public val periodUnit: Output<String>
        get() = javaResource.periodUnit().applyValue({ args0 -> args0 })

    /**
     * The time when the Storage Capacity Unit takes effect. It cannot be earlier than or more than six months later than the time when the Storage Capacity Unit is created. Specify the time in the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time must be in UTC. **NOTE:** This parameter is empty by default. The Storage Capacity Unit immediately takes effect after it is created.
     */
    public val startTime: Output<String>
        get() = javaResource.startTime().applyValue({ args0 -> args0 })

    /**
     * The status of Storage Capacity Unit.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The name of the Storage Capacity Unit.
     */
    public val storageCapacityUnitName: Output<String>
        get() = javaResource.storageCapacityUnitName().applyValue({ args0 -> args0 })
}

public object StorageCapacityUnitMapper : ResourceMapper<StorageCapacityUnit> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ecs.StorageCapacityUnit::class == javaResource::class

    override fun map(javaResource: Resource): StorageCapacityUnit = StorageCapacityUnit(
        javaResource
            as com.pulumi.alicloud.ecs.StorageCapacityUnit,
    )
}

/**
 * @see [StorageCapacityUnit].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StorageCapacityUnit].
 */
public suspend fun storageCapacityUnit(
    name: String,
    block: suspend StorageCapacityUnitResourceBuilder.() -> Unit,
): StorageCapacityUnit {
    val builder = StorageCapacityUnitResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StorageCapacityUnit].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storageCapacityUnit(name: String): StorageCapacityUnit {
    val builder = StorageCapacityUnitResourceBuilder()
    builder.name(name)
    return builder.build()
}
