@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin

import com.pulumi.alicloud.ecs.StorageCapacityUnitArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ECS Storage Capacity Unit resource.
 * For information about ECS Storage Capacity Unit and how to use it, see [What is Storage Capacity Unit](https://www.alibabacloud.com/help/en/doc-detail/161157.html).
 * > **NOTE:** Available in v1.155.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ecs.StorageCapacityUnit("default", {
 *     capacity: 20,
 *     description: "tftestdescription",
 *     storageCapacityUnitName: "tftestname",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ecs.StorageCapacityUnit("default",
 *     capacity=20,
 *     description="tftestdescription",
 *     storage_capacity_unit_name="tftestname")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ecs.StorageCapacityUnit("default", new()
 *     {
 *         Capacity = 20,
 *         Description = "tftestdescription",
 *         StorageCapacityUnitName = "tftestname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewStorageCapacityUnit(ctx, "default", &ecs.StorageCapacityUnitArgs{
 * 			Capacity:                pulumi.Int(20),
 * 			Description:             pulumi.String("tftestdescription"),
 * 			StorageCapacityUnitName: pulumi.String("tftestname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.StorageCapacityUnit;
 * import com.pulumi.alicloud.ecs.StorageCapacityUnitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new StorageCapacityUnit("default", StorageCapacityUnitArgs.builder()
 *             .capacity(20)
 *             .description("tftestdescription")
 *             .storageCapacityUnitName("tftestname")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ecs:StorageCapacityUnit
 *     properties:
 *       capacity: 20
 *       description: tftestdescription
 *       storageCapacityUnitName: tftestname
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECS Storage Capacity Unit can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ecs/storageCapacityUnit:StorageCapacityUnit example <id>
 * ```
 * @property capacity The capacity of the Storage Capacity Unit. Unit: GiB. Valid values: `20`, `40`, `100`, `200`, `500`, `1024`, `2048`, `5120`, `10240`, `20480`, and `51200`.
 * @property description The description of the Storage Capacity Unit. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
 * @property period The validity period of the Storage Capacity Unit. Default value: `1`.
 * * When PeriodUnit is set to Month, Valid values: `1`, `2`, `3`, `6`.
 * * When PeriodUnit is set to Year, Valid values: `1`, `3`, `5`.
 * @property periodUnit The unit of the validity period of the Storage Capacity Unit. Default value: `Month`. Valid values: `Month`, `Year`.
 * @property startTime The time when the Storage Capacity Unit takes effect. It cannot be earlier than or more than six months later than the time when the Storage Capacity Unit is created. Specify the time in the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time must be in UTC. **NOTE:** This parameter is empty by default. The Storage Capacity Unit immediately takes effect after it is created.
 * @property storageCapacityUnitName The name of the Storage Capacity Unit.
 */
public data class StorageCapacityUnitArgs(
    public val capacity: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val periodUnit: Output<String>? = null,
    public val startTime: Output<String>? = null,
    public val storageCapacityUnitName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.StorageCapacityUnitArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.StorageCapacityUnitArgs =
        com.pulumi.alicloud.ecs.StorageCapacityUnitArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodUnit(periodUnit?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .storageCapacityUnitName(storageCapacityUnitName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageCapacityUnitArgs].
 */
@PulumiTagMarker
public class StorageCapacityUnitArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var description: Output<String>? = null

    private var period: Output<Int>? = null

    private var periodUnit: Output<String>? = null

    private var startTime: Output<String>? = null

    private var storageCapacityUnitName: Output<String>? = null

    /**
     * @param value The capacity of the Storage Capacity Unit. Unit: GiB. Valid values: `20`, `40`, `100`, `200`, `500`, `1024`, `2048`, `5120`, `10240`, `20480`, and `51200`.
     */
    @JvmName("giwraujxouisxmut")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value The description of the Storage Capacity Unit. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
     */
    @JvmName("kdaruldoiuegwsee")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The validity period of the Storage Capacity Unit. Default value: `1`.
     * * When PeriodUnit is set to Month, Valid values: `1`, `2`, `3`, `6`.
     * * When PeriodUnit is set to Year, Valid values: `1`, `3`, `5`.
     */
    @JvmName("kcmukfmfriaqcctc")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The unit of the validity period of the Storage Capacity Unit. Default value: `Month`. Valid values: `Month`, `Year`.
     */
    @JvmName("rovkffearxwjhwtc")
    public suspend fun periodUnit(`value`: Output<String>) {
        this.periodUnit = value
    }

    /**
     * @param value The time when the Storage Capacity Unit takes effect. It cannot be earlier than or more than six months later than the time when the Storage Capacity Unit is created. Specify the time in the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time must be in UTC. **NOTE:** This parameter is empty by default. The Storage Capacity Unit immediately takes effect after it is created.
     */
    @JvmName("txwkfsggjheygcvf")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value The name of the Storage Capacity Unit.
     */
    @JvmName("npvolwyydyvnoqfo")
    public suspend fun storageCapacityUnitName(`value`: Output<String>) {
        this.storageCapacityUnitName = value
    }

    /**
     * @param value The capacity of the Storage Capacity Unit. Unit: GiB. Valid values: `20`, `40`, `100`, `200`, `500`, `1024`, `2048`, `5120`, `10240`, `20480`, and `51200`.
     */
    @JvmName("hojybalckqkijogs")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The description of the Storage Capacity Unit. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
     */
    @JvmName("haaurxradkydiqim")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The validity period of the Storage Capacity Unit. Default value: `1`.
     * * When PeriodUnit is set to Month, Valid values: `1`, `2`, `3`, `6`.
     * * When PeriodUnit is set to Year, Valid values: `1`, `3`, `5`.
     */
    @JvmName("rryljuuvauscyujq")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The unit of the validity period of the Storage Capacity Unit. Default value: `Month`. Valid values: `Month`, `Year`.
     */
    @JvmName("ffwrqonrqmsihddu")
    public suspend fun periodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodUnit = mapped
    }

    /**
     * @param value The time when the Storage Capacity Unit takes effect. It cannot be earlier than or more than six months later than the time when the Storage Capacity Unit is created. Specify the time in the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time must be in UTC. **NOTE:** This parameter is empty by default. The Storage Capacity Unit immediately takes effect after it is created.
     */
    @JvmName("bbgbvindexelouca")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value The name of the Storage Capacity Unit.
     */
    @JvmName("yepypqdrbdvjxdti")
    public suspend fun storageCapacityUnitName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageCapacityUnitName = mapped
    }

    internal fun build(): StorageCapacityUnitArgs = StorageCapacityUnitArgs(
        capacity = capacity,
        description = description,
        period = period,
        periodUnit = periodUnit,
        startTime = startTime,
        storageCapacityUnitName = storageCapacityUnitName,
    )
}
