@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.AutoProvisioningGroupLaunchTemplateConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceType The instance type of the Nth extended configurations of the launch template.
 * @property maxPrice The maximum price of the instance type specified in the Nth extended configurations of the launch template.
 * @property priority The priority of the instance type specified in the Nth extended configurations of the launch template. A value of 0 indicates the highest priority.
 * @property vswitchId The ID of the VSwitch in the Nth extended configurations of the launch template.
 * @property weightedCapacity The weight of the instance type specified in the Nth extended configurations of the launch template.
 */
public data class AutoProvisioningGroupLaunchTemplateConfigArgs(
    public val instanceType: Output<String>? = null,
    public val maxPrice: Output<String>,
    public val priority: Output<String>? = null,
    public val vswitchId: Output<String>,
    public val weightedCapacity: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.AutoProvisioningGroupLaunchTemplateConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.AutoProvisioningGroupLaunchTemplateConfigArgs =
        com.pulumi.alicloud.ecs.inputs.AutoProvisioningGroupLaunchTemplateConfigArgs.builder()
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .maxPrice(maxPrice.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId.applyValue({ args0 -> args0 }))
            .weightedCapacity(weightedCapacity.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoProvisioningGroupLaunchTemplateConfigArgs].
 */
@PulumiTagMarker
public class AutoProvisioningGroupLaunchTemplateConfigArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    private var maxPrice: Output<String>? = null

    private var priority: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var weightedCapacity: Output<String>? = null

    /**
     * @param value The instance type of the Nth extended configurations of the launch template.
     */
    @JvmName("icjffwstmqblobrg")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The maximum price of the instance type specified in the Nth extended configurations of the launch template.
     */
    @JvmName("isqcsixdfwwsjdng")
    public suspend fun maxPrice(`value`: Output<String>) {
        this.maxPrice = value
    }

    /**
     * @param value The priority of the instance type specified in the Nth extended configurations of the launch template. A value of 0 indicates the highest priority.
     */
    @JvmName("cndywyfebhdacxml")
    public suspend fun priority(`value`: Output<String>) {
        this.priority = value
    }

    /**
     * @param value The ID of the VSwitch in the Nth extended configurations of the launch template.
     */
    @JvmName("dpxgfceigiiglgro")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The weight of the instance type specified in the Nth extended configurations of the launch template.
     */
    @JvmName("uwnkmhdosfautles")
    public suspend fun weightedCapacity(`value`: Output<String>) {
        this.weightedCapacity = value
    }

    /**
     * @param value The instance type of the Nth extended configurations of the launch template.
     */
    @JvmName("bnutgcpgtgqfbfvk")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The maximum price of the instance type specified in the Nth extended configurations of the launch template.
     */
    @JvmName("ttqcsgtojahsvsxe")
    public suspend fun maxPrice(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxPrice = mapped
    }

    /**
     * @param value The priority of the instance type specified in the Nth extended configurations of the launch template. A value of 0 indicates the highest priority.
     */
    @JvmName("msaxcfemgakfkcax")
    public suspend fun priority(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The ID of the VSwitch in the Nth extended configurations of the launch template.
     */
    @JvmName("fmkghabtovstxrjn")
    public suspend fun vswitchId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The weight of the instance type specified in the Nth extended configurations of the launch template.
     */
    @JvmName("djgbatuuxsanpmin")
    public suspend fun weightedCapacity(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weightedCapacity = mapped
    }

    internal fun build(): AutoProvisioningGroupLaunchTemplateConfigArgs =
        AutoProvisioningGroupLaunchTemplateConfigArgs(
            instanceType = instanceType,
            maxPrice = maxPrice ?: throw PulumiNullFieldException("maxPrice"),
            priority = priority,
            vswitchId = vswitchId ?: throw PulumiNullFieldException("vswitchId"),
            weightedCapacity = weightedCapacity ?: throw PulumiNullFieldException("weightedCapacity"),
        )
}
