@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.DedicatedHostNetworkAttributeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property slbUdpTimeout The timeout period for a UDP session between Server Load Balancer (SLB) and the dedicated host. Unit: seconds. Valid values: 15 to 310.
 * @property udpTimeout The timeout period for a UDP session between a user and an Alibaba Cloud service on the dedicated host. Unit: seconds. Valid values: 15 to 310.
 */
public data class DedicatedHostNetworkAttributeArgs(
    public val slbUdpTimeout: Output<Int>? = null,
    public val udpTimeout: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.DedicatedHostNetworkAttributeArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.DedicatedHostNetworkAttributeArgs =
        com.pulumi.alicloud.ecs.inputs.DedicatedHostNetworkAttributeArgs.builder()
            .slbUdpTimeout(slbUdpTimeout?.applyValue({ args0 -> args0 }))
            .udpTimeout(udpTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DedicatedHostNetworkAttributeArgs].
 */
@PulumiTagMarker
public class DedicatedHostNetworkAttributeArgsBuilder internal constructor() {
    private var slbUdpTimeout: Output<Int>? = null

    private var udpTimeout: Output<Int>? = null

    /**
     * @param value The timeout period for a UDP session between Server Load Balancer (SLB) and the dedicated host. Unit: seconds. Valid values: 15 to 310.
     */
    @JvmName("lhohhxaexkbxcopr")
    public suspend fun slbUdpTimeout(`value`: Output<Int>) {
        this.slbUdpTimeout = value
    }

    /**
     * @param value The timeout period for a UDP session between a user and an Alibaba Cloud service on the dedicated host. Unit: seconds. Valid values: 15 to 310.
     */
    @JvmName("tqjbeyfxqgtqpqqk")
    public suspend fun udpTimeout(`value`: Output<Int>) {
        this.udpTimeout = value
    }

    /**
     * @param value The timeout period for a UDP session between Server Load Balancer (SLB) and the dedicated host. Unit: seconds. Valid values: 15 to 310.
     */
    @JvmName("jwunggpismjicghc")
    public suspend fun slbUdpTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slbUdpTimeout = mapped
    }

    /**
     * @param value The timeout period for a UDP session between a user and an Alibaba Cloud service on the dedicated host. Unit: seconds. Valid values: 15 to 310.
     */
    @JvmName("wofqhujwdrbfsmgn")
    public suspend fun udpTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.udpTimeout = mapped
    }

    internal fun build(): DedicatedHostNetworkAttributeArgs = DedicatedHostNetworkAttributeArgs(
        slbUdpTimeout = slbUdpTimeout,
        udpTimeout = udpTimeout,
    )
}
