@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.EcsInstanceSetDataDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoSnapshotPolicyId The ID of the automatic snapshot policy applied to the system disk.
 * @property diskCategory The category of the disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
 * @property diskDescription The description of the data disk.
 * @property diskName The name of the data disk.
 * @property diskSize The size of the data disk. Unit: GiB.
 * - When `disk_category` is `cloud_efficiency`, Valid values: `20` to `32768`.
 * - When `disk_category` is `cloud_ssd`, Valid values: `20` to `32768`.
 * - When `disk_category` is `cloud_essd`, Valid values: `20` to `32768`.
 * - When `disk_category` is `cloud`, Valid values: `5` to `200`.
 * @property encrypted Encrypted the data in this disk. Default value: `false`.
 * @property kmsKeyId The KMS key ID corresponding to the data disk.
 * @property performanceLevel The performance level of the ESSD used as data disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
 * @property snapshotId The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
 */
public data class EcsInstanceSetDataDiskArgs(
    public val autoSnapshotPolicyId: Output<String>? = null,
    public val diskCategory: Output<String>? = null,
    public val diskDescription: Output<String>? = null,
    public val diskName: Output<String>? = null,
    public val diskSize: Output<Int>,
    public val encrypted: Output<Boolean>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val performanceLevel: Output<String>? = null,
    public val snapshotId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.EcsInstanceSetDataDiskArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.EcsInstanceSetDataDiskArgs =
        com.pulumi.alicloud.ecs.inputs.EcsInstanceSetDataDiskArgs.builder()
            .autoSnapshotPolicyId(autoSnapshotPolicyId?.applyValue({ args0 -> args0 }))
            .diskCategory(diskCategory?.applyValue({ args0 -> args0 }))
            .diskDescription(diskDescription?.applyValue({ args0 -> args0 }))
            .diskName(diskName?.applyValue({ args0 -> args0 }))
            .diskSize(diskSize.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .performanceLevel(performanceLevel?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcsInstanceSetDataDiskArgs].
 */
@PulumiTagMarker
public class EcsInstanceSetDataDiskArgsBuilder internal constructor() {
    private var autoSnapshotPolicyId: Output<String>? = null

    private var diskCategory: Output<String>? = null

    private var diskDescription: Output<String>? = null

    private var diskName: Output<String>? = null

    private var diskSize: Output<Int>? = null

    private var encrypted: Output<Boolean>? = null

    private var kmsKeyId: Output<String>? = null

    private var performanceLevel: Output<String>? = null

    private var snapshotId: Output<String>? = null

    /**
     * @param value The ID of the automatic snapshot policy applied to the system disk.
     */
    @JvmName("vuudfyfknybpsauv")
    public suspend fun autoSnapshotPolicyId(`value`: Output<String>) {
        this.autoSnapshotPolicyId = value
    }

    /**
     * @param value The category of the disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
     */
    @JvmName("tdwapsrrgkbuquwr")
    public suspend fun diskCategory(`value`: Output<String>) {
        this.diskCategory = value
    }

    /**
     * @param value The description of the data disk.
     */
    @JvmName("edyuocjtuqoxsdka")
    public suspend fun diskDescription(`value`: Output<String>) {
        this.diskDescription = value
    }

    /**
     * @param value The name of the data disk.
     */
    @JvmName("fgwdvkrwvurgtcjb")
    public suspend fun diskName(`value`: Output<String>) {
        this.diskName = value
    }

    /**
     * @param value The size of the data disk. Unit: GiB.
     * - When `disk_category` is `cloud_efficiency`, Valid values: `20` to `32768`.
     * - When `disk_category` is `cloud_ssd`, Valid values: `20` to `32768`.
     * - When `disk_category` is `cloud_essd`, Valid values: `20` to `32768`.
     * - When `disk_category` is `cloud`, Valid values: `5` to `200`.
     */
    @JvmName("semtlgtklrbsqhyq")
    public suspend fun diskSize(`value`: Output<Int>) {
        this.diskSize = value
    }

    /**
     * @param value Encrypted the data in this disk. Default value: `false`.
     */
    @JvmName("tcryxiegxgacyiyk")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value The KMS key ID corresponding to the data disk.
     */
    @JvmName("dygirqisvpyhjgvg")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The performance level of the ESSD used as data disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
     */
    @JvmName("lswslyyluuwgnuae")
    public suspend fun performanceLevel(`value`: Output<String>) {
        this.performanceLevel = value
    }

    /**
     * @param value The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
     */
    @JvmName("minognxqwyicjepr")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value The ID of the automatic snapshot policy applied to the system disk.
     */
    @JvmName("syrkjnaroyhafvmp")
    public suspend fun autoSnapshotPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoSnapshotPolicyId = mapped
    }

    /**
     * @param value The category of the disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
     */
    @JvmName("fyqhggcvbmdaxffw")
    public suspend fun diskCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskCategory = mapped
    }

    /**
     * @param value The description of the data disk.
     */
    @JvmName("vuxitohbeflpenxa")
    public suspend fun diskDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskDescription = mapped
    }

    /**
     * @param value The name of the data disk.
     */
    @JvmName("mropygdwcbhptfck")
    public suspend fun diskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskName = mapped
    }

    /**
     * @param value The size of the data disk. Unit: GiB.
     * - When `disk_category` is `cloud_efficiency`, Valid values: `20` to `32768`.
     * - When `disk_category` is `cloud_ssd`, Valid values: `20` to `32768`.
     * - When `disk_category` is `cloud_essd`, Valid values: `20` to `32768`.
     * - When `disk_category` is `cloud`, Valid values: `5` to `200`.
     */
    @JvmName("crslisgblfxnwfil")
    public suspend fun diskSize(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskSize = mapped
    }

    /**
     * @param value Encrypted the data in this disk. Default value: `false`.
     */
    @JvmName("gijqjdrpjoggmefi")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value The KMS key ID corresponding to the data disk.
     */
    @JvmName("cbqpowdtqrilcdia")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The performance level of the ESSD used as data disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
     */
    @JvmName("kgqdsdcpmfmwsprm")
    public suspend fun performanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceLevel = mapped
    }

    /**
     * @param value The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
     */
    @JvmName("axundohgrkjrvvqf")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    internal fun build(): EcsInstanceSetDataDiskArgs = EcsInstanceSetDataDiskArgs(
        autoSnapshotPolicyId = autoSnapshotPolicyId,
        diskCategory = diskCategory,
        diskDescription = diskDescription,
        diskName = diskName,
        diskSize = diskSize ?: throw PulumiNullFieldException("diskSize"),
        encrypted = encrypted,
        kmsKeyId = kmsKeyId,
        performanceLevel = performanceLevel,
        snapshotId = snapshotId,
    )
}
