@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.EcsInstanceSetExcludeInstanceFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key The type of the excluded. Valid values: `InstanceId`, `InstanceName`.
 * @property values The value of the excluded. The identification of the excluded instances. It is a list of instance Ids or names.
 */
public data class EcsInstanceSetExcludeInstanceFilterArgs(
    public val key: Output<String>,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.EcsInstanceSetExcludeInstanceFilterArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.EcsInstanceSetExcludeInstanceFilterArgs =
        com.pulumi.alicloud.ecs.inputs.EcsInstanceSetExcludeInstanceFilterArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [EcsInstanceSetExcludeInstanceFilterArgs].
 */
@PulumiTagMarker
public class EcsInstanceSetExcludeInstanceFilterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value The type of the excluded. Valid values: `InstanceId`, `InstanceName`.
     */
    @JvmName("iiayuivnarixbplm")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The value of the excluded. The identification of the excluded instances. It is a list of instance Ids or names.
     */
    @JvmName("mnutfcpsqiigjrol")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("rhkglsxpaiswemnw")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The value of the excluded. The identification of the excluded instances. It is a list of instance Ids or names.
     */
    @JvmName("pqeejcswkbwvopcg")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The type of the excluded. Valid values: `InstanceId`, `InstanceName`.
     */
    @JvmName("pydolpfmpvosvfjb")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The value of the excluded. The identification of the excluded instances. It is a list of instance Ids or names.
     */
    @JvmName("flxugetbfacsoodf")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values The value of the excluded. The identification of the excluded instances. It is a list of instance Ids or names.
     */
    @JvmName("xsvhsadvhbafckvk")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): EcsInstanceSetExcludeInstanceFilterArgs =
        EcsInstanceSetExcludeInstanceFilterArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            values = values ?: throw PulumiNullFieldException("values"),
        )
}
