@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.EcsInstanceSetNetworkInterfaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description The description of ENI.
 * @property networkInterfaceName The name of ENI.
 * @property primaryIpAddress The primary private IP address of ENI.
 * @property securityGroupId The ID of the security group to which to assign secondary ENI.
 * @property vswitchId The ID of the vSwitch to which to connect ENI.
 */
public data class EcsInstanceSetNetworkInterfaceArgs(
    public val description: Output<String>? = null,
    public val networkInterfaceName: Output<String>? = null,
    public val primaryIpAddress: Output<String>? = null,
    public val securityGroupId: Output<String>,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.EcsInstanceSetNetworkInterfaceArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.EcsInstanceSetNetworkInterfaceArgs =
        com.pulumi.alicloud.ecs.inputs.EcsInstanceSetNetworkInterfaceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .networkInterfaceName(networkInterfaceName?.applyValue({ args0 -> args0 }))
            .primaryIpAddress(primaryIpAddress?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcsInstanceSetNetworkInterfaceArgs].
 */
@PulumiTagMarker
public class EcsInstanceSetNetworkInterfaceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var networkInterfaceName: Output<String>? = null

    private var primaryIpAddress: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value The description of ENI.
     */
    @JvmName("mmhgnyegoobtiyyh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of ENI.
     */
    @JvmName("rhugpxyipngqjpak")
    public suspend fun networkInterfaceName(`value`: Output<String>) {
        this.networkInterfaceName = value
    }

    /**
     * @param value The primary private IP address of ENI.
     */
    @JvmName("gxwlttclhlididoo")
    public suspend fun primaryIpAddress(`value`: Output<String>) {
        this.primaryIpAddress = value
    }

    /**
     * @param value The ID of the security group to which to assign secondary ENI.
     */
    @JvmName("cjwujllcwrkjimgb")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value The ID of the vSwitch to which to connect ENI.
     */
    @JvmName("bijtuqyhnonrprhi")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The description of ENI.
     */
    @JvmName("hocpfvyxnpsgceua")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of ENI.
     */
    @JvmName("mcngigfgmrhnjxyu")
    public suspend fun networkInterfaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceName = mapped
    }

    /**
     * @param value The primary private IP address of ENI.
     */
    @JvmName("fiirmsxoogepaoui")
    public suspend fun primaryIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryIpAddress = mapped
    }

    /**
     * @param value The ID of the security group to which to assign secondary ENI.
     */
    @JvmName("kstaliahtrwhnrtq")
    public suspend fun securityGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value The ID of the vSwitch to which to connect ENI.
     */
    @JvmName("psigkfxtmkramhfw")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): EcsInstanceSetNetworkInterfaceArgs = EcsInstanceSetNetworkInterfaceArgs(
        description = description,
        networkInterfaceName = networkInterfaceName,
        primaryIpAddress = primaryIpAddress,
        securityGroupId = securityGroupId ?: throw PulumiNullFieldException("securityGroupId"),
        vswitchId = vswitchId,
    )
}
