@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.EcsLaunchTemplateDataDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property category The category of the disk.
 * @property deleteWithInstance Indicates whether the data disk is released with the instance.
 * @property description The description of the data disk.
 * @property encrypted Encrypted the data in this disk.
 * @property name The name of the data disk.
 * @property performanceLevel The performance level of the ESSD used as the data disk.
 * @property size The size of the data disk.
 * @property snapshotId The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
 */
public data class EcsLaunchTemplateDataDiskArgs(
    public val category: Output<String>? = null,
    public val deleteWithInstance: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val performanceLevel: Output<String>? = null,
    public val size: Output<Int>? = null,
    public val snapshotId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.EcsLaunchTemplateDataDiskArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.EcsLaunchTemplateDataDiskArgs =
        com.pulumi.alicloud.ecs.inputs.EcsLaunchTemplateDataDiskArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .deleteWithInstance(deleteWithInstance?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .performanceLevel(performanceLevel?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcsLaunchTemplateDataDiskArgs].
 */
@PulumiTagMarker
public class EcsLaunchTemplateDataDiskArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var deleteWithInstance: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var performanceLevel: Output<String>? = null

    private var size: Output<Int>? = null

    private var snapshotId: Output<String>? = null

    /**
     * @param value The category of the disk.
     */
    @JvmName("nhyrtewgaddnvbmw")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Indicates whether the data disk is released with the instance.
     */
    @JvmName("useoweyacikvrafb")
    public suspend fun deleteWithInstance(`value`: Output<Boolean>) {
        this.deleteWithInstance = value
    }

    /**
     * @param value The description of the data disk.
     */
    @JvmName("wrjpqorenwafyfqc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Encrypted the data in this disk.
     */
    @JvmName("hncacowjxifaqvmp")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value The name of the data disk.
     */
    @JvmName("jkdeppfcgwdhahuf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The performance level of the ESSD used as the data disk.
     */
    @JvmName("rfgicicprytmyben")
    public suspend fun performanceLevel(`value`: Output<String>) {
        this.performanceLevel = value
    }

    /**
     * @param value The size of the data disk.
     */
    @JvmName("grsyvcbxulyjbgva")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
     */
    @JvmName("pffreocksugwoxay")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value The category of the disk.
     */
    @JvmName("gcxddfmkiuxmbwxv")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Indicates whether the data disk is released with the instance.
     */
    @JvmName("oxrwaxqvbtpjtepm")
    public suspend fun deleteWithInstance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteWithInstance = mapped
    }

    /**
     * @param value The description of the data disk.
     */
    @JvmName("ccywcrpribedwwxy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Encrypted the data in this disk.
     */
    @JvmName("suwpclfurteanrxk")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value The name of the data disk.
     */
    @JvmName("qorqjgmqodfrqctu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The performance level of the ESSD used as the data disk.
     */
    @JvmName("bgwsjbqcpaaqsewj")
    public suspend fun performanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceLevel = mapped
    }

    /**
     * @param value The size of the data disk.
     */
    @JvmName("xjhoqreymbmjbruh")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
     */
    @JvmName("pgugrtmuqauiepyc")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    internal fun build(): EcsLaunchTemplateDataDiskArgs = EcsLaunchTemplateDataDiskArgs(
        category = category,
        deleteWithInstance = deleteWithInstance,
        description = description,
        encrypted = encrypted,
        name = name,
        performanceLevel = performanceLevel,
        size = size,
        snapshotId = snapshotId,
    )
}
