@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.EcsLaunchTemplateSystemDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property category The category of the system disk. System disk type. Valid values: `all`, `cloud`, `ephemeral_ssd`, `cloud_essd`, `cloud_efficiency`, `cloud_ssd`, `local_disk`.
 * @property deleteWithInstance Specifies whether to release the system disk when the instance is released. Default to `true`.
 * @property description System disk description. It cannot begin with http:// or https://.
 * @property encrypted Specifies whether the system disk is encrypted.
 * @property iops The Iops.
 * @property name System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
 * @property performanceLevel The performance level of the ESSD used as the system disk. Valid Values: `PL0`, `PL1`, `PL2`, and `PL3`. Default to: `PL0`.
 * @property size Size of the system disk, measured in GB. Value range: [20, 500].
 */
public data class EcsLaunchTemplateSystemDiskArgs(
    public val category: Output<String>? = null,
    public val deleteWithInstance: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val iops: Output<String>? = null,
    public val name: Output<String>? = null,
    public val performanceLevel: Output<String>? = null,
    public val size: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.EcsLaunchTemplateSystemDiskArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.EcsLaunchTemplateSystemDiskArgs =
        com.pulumi.alicloud.ecs.inputs.EcsLaunchTemplateSystemDiskArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .deleteWithInstance(deleteWithInstance?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .iops(iops?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .performanceLevel(performanceLevel?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EcsLaunchTemplateSystemDiskArgs].
 */
@PulumiTagMarker
public class EcsLaunchTemplateSystemDiskArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var deleteWithInstance: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var iops: Output<String>? = null

    private var name: Output<String>? = null

    private var performanceLevel: Output<String>? = null

    private var size: Output<Int>? = null

    /**
     * @param value The category of the system disk. System disk type. Valid values: `all`, `cloud`, `ephemeral_ssd`, `cloud_essd`, `cloud_efficiency`, `cloud_ssd`, `local_disk`.
     */
    @JvmName("bwlxrijesdtbqspq")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Specifies whether to release the system disk when the instance is released. Default to `true`.
     */
    @JvmName("ujypyjdkcvkhwaqy")
    public suspend fun deleteWithInstance(`value`: Output<Boolean>) {
        this.deleteWithInstance = value
    }

    /**
     * @param value System disk description. It cannot begin with http:// or https://.
     */
    @JvmName("jmitquitnhiokpdd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether the system disk is encrypted.
     */
    @JvmName("xcbohenjkrbefoce")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value The Iops.
     */
    @JvmName("uhvvleplfvtanxss")
    public suspend fun iops(`value`: Output<String>) {
        this.iops = value
    }

    /**
     * @param value System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
     */
    @JvmName("oeajmoejvfxksjtc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The performance level of the ESSD used as the system disk. Valid Values: `PL0`, `PL1`, `PL2`, and `PL3`. Default to: `PL0`.
     */
    @JvmName("mrcdknptorbbearx")
    public suspend fun performanceLevel(`value`: Output<String>) {
        this.performanceLevel = value
    }

    /**
     * @param value Size of the system disk, measured in GB. Value range: [20, 500].
     */
    @JvmName("alnekukvjufktpih")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The category of the system disk. System disk type. Valid values: `all`, `cloud`, `ephemeral_ssd`, `cloud_essd`, `cloud_efficiency`, `cloud_ssd`, `local_disk`.
     */
    @JvmName("jwufpgjlfagiftjh")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Specifies whether to release the system disk when the instance is released. Default to `true`.
     */
    @JvmName("txbmuttmhnpyluyo")
    public suspend fun deleteWithInstance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteWithInstance = mapped
    }

    /**
     * @param value System disk description. It cannot begin with http:// or https://.
     */
    @JvmName("ttahycosucvnpkgc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether the system disk is encrypted.
     */
    @JvmName("xdygkabuhvsvwrpu")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value The Iops.
     */
    @JvmName("ydatjqgvswuumaux")
    public suspend fun iops(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
     */
    @JvmName("ubquhichsqmfbymb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The performance level of the ESSD used as the system disk. Valid Values: `PL0`, `PL1`, `PL2`, and `PL3`. Default to: `PL0`.
     */
    @JvmName("tmgsrxxwvwuedlbi")
    public suspend fun performanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceLevel = mapped
    }

    /**
     * @param value Size of the system disk, measured in GB. Value range: [20, 500].
     */
    @JvmName("hjodrulgkmmewyyg")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    internal fun build(): EcsLaunchTemplateSystemDiskArgs = EcsLaunchTemplateSystemDiskArgs(
        category = category,
        deleteWithInstance = deleteWithInstance,
        description = description,
        encrypted = encrypted,
        iops = iops,
        name = name,
        performanceLevel = performanceLevel,
        size = size,
    )
}
