@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetAutoSnapshotPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAutoSnapshotPolicies.
 * @property ids A list of Auto Snapshot Policy IDs.
 * @property nameRegex A regex string to filter results by Auto Snapshot Policy name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of Auto Snapshot Policy. Valid Values: `Expire`, `Normal`.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetAutoSnapshotPoliciesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetAutoSnapshotPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetAutoSnapshotPoliciesPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetAutoSnapshotPoliciesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetAutoSnapshotPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetAutoSnapshotPoliciesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value A list of Auto Snapshot Policy IDs.
     */
    @JvmName("rsjovtmfmtwdqalj")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Auto Snapshot Policy IDs.
     */
    @JvmName("wqpurxaffgywvrxf")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Auto Snapshot Policy name.
     */
    @JvmName("rmvbtmhbbiaemvfe")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dgfsbhxbhiobthcm")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of Auto Snapshot Policy. Valid Values: `Expire`, `Normal`.
     */
    @JvmName("xxahjvvbmmcmcevb")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("mfofcvvhqymswftp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("iqrngkdsuxxgqwtn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetAutoSnapshotPoliciesPlainArgs = GetAutoSnapshotPoliciesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
        tags = tags,
    )
}
