@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetCapacityReservationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCapacityReservations.
 * @property capacityReservationIds
 * @property ids A list of Capacity Reservation IDs.
 * @property instanceType Instance type. Currently, you can only set the capacity reservation service for one instance type.
 * @property nameRegex A regex string to filter results by Group Metric Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property paymentType The payment type of the resource. value range `PostPaid`, `PrePaid`.
 * @property platform platform of the capacity reservation , value range `windows`, `linux`, `all`.
 * @property resourceGroupId The resource group id.
 * @property status The status of the capacity reservation. value range `All`, `Pending`, `Preparing`, `Prepared`, `Active`, `Released`.
 * @property tags The tag of the resource.
 */
public data class GetCapacityReservationsPlainArgs(
    public val capacityReservationIds: List<String>? = null,
    public val ids: List<String>? = null,
    public val instanceType: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val paymentType: String? = null,
    public val platform: String? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetCapacityReservationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetCapacityReservationsPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetCapacityReservationsPlainArgs.builder()
            .capacityReservationIds(capacityReservationIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceType(instanceType?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .paymentType(paymentType?.let({ args0 -> args0 }))
            .platform(platform?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetCapacityReservationsPlainArgs].
 */
@PulumiTagMarker
public class GetCapacityReservationsPlainArgsBuilder internal constructor() {
    private var capacityReservationIds: List<String>? = null

    private var ids: List<String>? = null

    private var instanceType: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var paymentType: String? = null

    private var platform: String? = null

    private var resourceGroupId: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value
     */
    @JvmName("oantcecnlkesxkdf")
    public suspend fun capacityReservationIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.capacityReservationIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("sqeloatheakfsvue")
    public suspend fun capacityReservationIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.capacityReservationIds = mapped
    }

    /**
     * @param value A list of Capacity Reservation IDs.
     */
    @JvmName("vhqdemryeidjalpj")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Capacity Reservation IDs.
     */
    @JvmName("nuyxyxuhsugdhmpr")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Instance type. Currently, you can only set the capacity reservation service for one instance type.
     */
    @JvmName("eaigkhnbgecljdqv")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceType = mapped
    }

    /**
     * @param value A regex string to filter results by Group Metric Rule name.
     */
    @JvmName("ykmnosdnusqtgist")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("lvwqgosnoupvpqpm")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The payment type of the resource. value range `PostPaid`, `PrePaid`.
     */
    @JvmName("phybgxneeomphypg")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.paymentType = mapped
    }

    /**
     * @param value platform of the capacity reservation , value range `windows`, `linux`, `all`.
     */
    @JvmName("uakncclmvpatnvdf")
    public suspend fun platform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.platform = mapped
    }

    /**
     * @param value The resource group id.
     */
    @JvmName("bfbyrtrutobbnpgc")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The status of the capacity reservation. value range `All`, `Pending`, `Preparing`, `Prepared`, `Active`, `Released`.
     */
    @JvmName("tvknjejjygjmycwp")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("mbxcjxukpwakmvgq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource.
     */
    @JvmName("iiiakgwylwoastku")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetCapacityReservationsPlainArgs = GetCapacityReservationsPlainArgs(
        capacityReservationIds = capacityReservationIds,
        ids = ids,
        instanceType = instanceType,
        nameRegex = nameRegex,
        outputFile = outputFile,
        paymentType = paymentType,
        platform = platform,
        resourceGroupId = resourceGroupId,
        status = status,
        tags = tags,
    )
}
