@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetCommandsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCommands.
 * @property commandProvider Public order provider.
 * @property contentEncoding The Base64-encoded content of the command.
 * @property description The description of command.
 * @property ids A list of Command IDs.
 * @property name The name of the command.
 * @property nameRegex A regex string to filter results by Command name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property type The command type. Valid Values: `RunBatScript`, `RunPowerShellScript` and `RunShellScript`.
 */
public data class GetCommandsPlainArgs(
    public val commandProvider: String? = null,
    public val contentEncoding: String? = null,
    public val description: String? = null,
    public val ids: List<String>? = null,
    public val name: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val type: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetCommandsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetCommandsPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetCommandsPlainArgs.builder()
            .commandProvider(commandProvider?.let({ args0 -> args0 }))
            .contentEncoding(contentEncoding?.let({ args0 -> args0 }))
            .description(description?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .type(type?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCommandsPlainArgs].
 */
@PulumiTagMarker
public class GetCommandsPlainArgsBuilder internal constructor() {
    private var commandProvider: String? = null

    private var contentEncoding: String? = null

    private var description: String? = null

    private var ids: List<String>? = null

    private var name: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var type: String? = null

    /**
     * @param value Public order provider.
     */
    @JvmName("gkjjfnnmefyfjnth")
    public suspend fun commandProvider(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.commandProvider = mapped
    }

    /**
     * @param value The Base64-encoded content of the command.
     */
    @JvmName("losokgpvpgpswqjp")
    public suspend fun contentEncoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.contentEncoding = mapped
    }

    /**
     * @param value The description of command.
     */
    @JvmName("jyxbvnfbvaoxuwbf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value A list of Command IDs.
     */
    @JvmName("plniewqrepjvsxkh")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Command IDs.
     */
    @JvmName("wuynqlckquuayxul")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The name of the command.
     */
    @JvmName("laqehyarbyodpcim")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value A regex string to filter results by Command name.
     */
    @JvmName("hrlabebvnntxpmxn")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("fccawdjunvxftcwh")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The command type. Valid Values: `RunBatScript`, `RunPowerShellScript` and `RunShellScript`.
     */
    @JvmName("yuanneqblixalylv")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetCommandsPlainArgs = GetCommandsPlainArgs(
        commandProvider = commandProvider,
        contentEncoding = contentEncoding,
        description = description,
        ids = ids,
        name = name,
        nameRegex = nameRegex,
        outputFile = outputFile,
        type = type,
    )
}
