@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetDedicatedHostsOperationLock.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property lockReason The reason why the dedicated host resource is locked.
 */
public data class GetDedicatedHostsOperationLock(
    public val lockReason: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetDedicatedHostsOperationLock> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetDedicatedHostsOperationLock =
        com.pulumi.alicloud.ecs.inputs.GetDedicatedHostsOperationLock.builder()
            .lockReason(lockReason?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDedicatedHostsOperationLock].
 */
@PulumiTagMarker
public class GetDedicatedHostsOperationLockBuilder internal constructor() {
    private var lockReason: String? = null

    /**
     * @param value The reason why the dedicated host resource is locked.
     */
    @JvmName("yghknwagdhnwrsdn")
    public suspend fun lockReason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lockReason = mapped
    }

    internal fun build(): GetDedicatedHostsOperationLock = GetDedicatedHostsOperationLock(
        lockReason = lockReason,
    )
}
