@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetDedicatedHostsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDedicatedHosts.
 * @property dedicatedHostId The ID of ECS Dedicated Host.
 * @property dedicatedHostName The name of ECS Dedicated Host.
 * @property dedicatedHostType The type of the dedicated host.
 * @property ids A list of ECS Dedicated Host ids.
 * @property nameRegex A regex string to filter results by the ECS Dedicated Host name.
 * @property operationLocks The reason why the dedicated host resource is locked.
 * @property outputFile Save the result to the file.
 * @property resourceGroupId The ID of the resource group to which the ECS Dedicated Host belongs.
 * @property status The status of the ECS Dedicated Host. validate value: `Available`, `Creating`, `PermanentFailure`, `Released`, `UnderAssessment`.
 * @property tags A mapping of tags to assign to the resource.
 * @property zoneId The zone ID of the ECS Dedicated Host.
 */
public data class GetDedicatedHostsPlainArgs(
    public val dedicatedHostId: String? = null,
    public val dedicatedHostName: String? = null,
    public val dedicatedHostType: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val operationLocks: List<GetDedicatedHostsOperationLock>? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetDedicatedHostsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetDedicatedHostsPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetDedicatedHostsPlainArgs.builder()
            .dedicatedHostId(dedicatedHostId?.let({ args0 -> args0 }))
            .dedicatedHostName(dedicatedHostName?.let({ args0 -> args0 }))
            .dedicatedHostType(dedicatedHostType?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .operationLocks(
                operationLocks?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDedicatedHostsPlainArgs].
 */
@PulumiTagMarker
public class GetDedicatedHostsPlainArgsBuilder internal constructor() {
    private var dedicatedHostId: String? = null

    private var dedicatedHostName: String? = null

    private var dedicatedHostType: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var operationLocks: List<GetDedicatedHostsOperationLock>? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var zoneId: String? = null

    /**
     * @param value The ID of ECS Dedicated Host.
     */
    @JvmName("grwljglvuvpfstfb")
    public suspend fun dedicatedHostId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dedicatedHostId = mapped
    }

    /**
     * @param value The name of ECS Dedicated Host.
     */
    @JvmName("aqpflfmgcnoohall")
    public suspend fun dedicatedHostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dedicatedHostName = mapped
    }

    /**
     * @param value The type of the dedicated host.
     */
    @JvmName("xvbniroixlxjqplm")
    public suspend fun dedicatedHostType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dedicatedHostType = mapped
    }

    /**
     * @param value A list of ECS Dedicated Host ids.
     */
    @JvmName("csmlelvjoemvyxkp")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of ECS Dedicated Host ids.
     */
    @JvmName("tktehylhpohflqhg")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by the ECS Dedicated Host name.
     */
    @JvmName("axxdfrkqqjdjpjsy")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The reason why the dedicated host resource is locked.
     */
    @JvmName("vitlxdeuqxxtkpwx")
    public suspend fun operationLocks(`value`: List<GetDedicatedHostsOperationLock>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.operationLocks = mapped
    }

    /**
     * @param argument The reason why the dedicated host resource is locked.
     */
    @JvmName("jvycjhdgestmkbte")
    public suspend fun operationLocks(argument: List<suspend GetDedicatedHostsOperationLockBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetDedicatedHostsOperationLockBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.operationLocks = mapped
    }

    /**
     * @param argument The reason why the dedicated host resource is locked.
     */
    @JvmName("kyakmkhbhehqncgl")
    public suspend fun operationLocks(vararg argument: suspend GetDedicatedHostsOperationLockBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetDedicatedHostsOperationLockBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.operationLocks = mapped
    }

    /**
     * @param argument The reason why the dedicated host resource is locked.
     */
    @JvmName("txdyseivlpaylqsu")
    public suspend fun operationLocks(argument: suspend GetDedicatedHostsOperationLockBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetDedicatedHostsOperationLockBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.operationLocks = mapped
    }

    /**
     * @param values The reason why the dedicated host resource is locked.
     */
    @JvmName("fclbmkkcimyameus")
    public suspend fun operationLocks(vararg values: GetDedicatedHostsOperationLock) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.operationLocks = mapped
    }

    /**
     * @param value Save the result to the file.
     */
    @JvmName("fmarijfwuydqleeo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the resource group to which the ECS Dedicated Host belongs.
     */
    @JvmName("ocasvaowchmxckik")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The status of the ECS Dedicated Host. validate value: `Available`, `Creating`, `PermanentFailure`, `Released`, `UnderAssessment`.
     */
    @JvmName("ugsikyvaqvdefmbu")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("ypdfaqgcawgrcupm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("janvwawlmmwbasfd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value The zone ID of the ECS Dedicated Host.
     */
    @JvmName("bctpgxxqskcaiuge")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetDedicatedHostsPlainArgs = GetDedicatedHostsPlainArgs(
        dedicatedHostId = dedicatedHostId,
        dedicatedHostName = dedicatedHostName,
        dedicatedHostType = dedicatedHostType,
        ids = ids,
        nameRegex = nameRegex,
        operationLocks = operationLocks,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        status = status,
        tags = tags,
        zoneId = zoneId,
    )
}
