@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetDisksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDisks.
 * @property additionalAttributes
 * @property autoSnapshotPolicyId
 * @property availabilityZone Availability zone of the disk.
 * @property category Disk category. Possible values: `cloud` (basic cloud disk), `cloud_efficiency` (ultra cloud disk), `ephemeral_ssd` (local SSD cloud disk), `cloud_ssd` (SSD cloud disk), and `cloud_essd` (ESSD cloud disk), `cloud_essd_entry`.
 * @property deleteAutoSnapshot
 * @property deleteWithInstance
 * @property diskName
 * @property diskType
 * @property dryRun
 * @property enableAutoSnapshot
 * @property enableAutomatedSnapshotPolicy
 * @property enableShared
 * @property encrypted Indicate whether the disk is encrypted or not. Possible values: `on` and `off`.
 * @property ids A list of disks IDs.
 * @property instanceId Filter the results by the specified ECS instance ID.
 * @property kmsKeyId
 * @property nameRegex A regex string to filter results by disk name.
 * @property operationLocks
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property paymentType
 * @property portable
 * @property resourceGroupId The Id of resource group which the disk belongs.
 * @property snapshotId Snapshot used to create the disk. It is null if no snapshot is used to create the disk.
 * @property status Current status. Possible values: `In_use`, `Available`, `Attaching`, `Detaching`, `Creating` and `ReIniting`.
 * @property tags A map of tags assigned to the disks. It must be in the format:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const disksDs = alicloud.ecs.getDisks({
 *     tags: {
 *         tagKey1: "tagValue1",
 *         tagKey2: "tagValue2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * disks_ds = alicloud.ecs.get_disks(tags={
 *     "tagKey1": "tagValue1",
 *     "tagKey2": "tagValue2",
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disksDs = AliCloud.Ecs.GetDisks.Invoke(new()
 *     {
 *         Tags =
 *         {
 *             { "tagKey1", "tagValue1" },
 *             { "tagKey2", "tagValue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.GetDisks(ctx, &ecs.GetDisksArgs{
 * 			Tags: map[string]interface{}{
 * 				"tagKey1": "tagValue1",
 * 				"tagKey2": "tagValue2",
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetDisksArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var disksDs = EcsFunctions.getDisks(GetDisksArgs.builder()
 *             .tags(Map.ofEntries(
 *                 Map.entry("tagKey1", "tagValue1"),
 *                 Map.entry("tagKey2", "tagValue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * variables:
 *   disksDs:
 *     fn::invoke:
 *       Function: alicloud:ecs:getDisks
 *       Arguments:
 *         tags:
 *           tagKey1: tagValue1
 *           tagKey2: tagValue2
 * ```
 * <!--End PulumiCodeChooser -->
 * @property type Disk type. Possible values: `system` and `data`.
 * @property zoneId
 */
public data class GetDisksPlainArgs(
    public val additionalAttributes: List<String>? = null,
    public val autoSnapshotPolicyId: String? = null,
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.122.0. New field 'zone_id'
      instead
  """,
    )
    public val availabilityZone: String? = null,
    public val category: String? = null,
    public val deleteAutoSnapshot: Boolean? = null,
    public val deleteWithInstance: Boolean? = null,
    public val diskName: String? = null,
    public val diskType: String? = null,
    public val dryRun: Boolean? = null,
    public val enableAutoSnapshot: Boolean? = null,
    public val enableAutomatedSnapshotPolicy: Boolean? = null,
    public val enableShared: Boolean? = null,
    public val encrypted: String? = null,
    public val ids: List<String>? = null,
    public val instanceId: String? = null,
    public val kmsKeyId: String? = null,
    public val nameRegex: String? = null,
    public val operationLocks: List<GetDisksOperationLock>? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val paymentType: String? = null,
    public val portable: Boolean? = null,
    public val resourceGroupId: String? = null,
    public val snapshotId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    @Deprecated(
        message = """
  Field 'type' has been deprecated from provider version 1.122.0. New field 'disk_type' instead.
  """,
    )
    public val type: String? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetDisksPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetDisksPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetDisksPlainArgs.builder()
            .additionalAttributes(additionalAttributes?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .autoSnapshotPolicyId(autoSnapshotPolicyId?.let({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.let({ args0 -> args0 }))
            .category(category?.let({ args0 -> args0 }))
            .deleteAutoSnapshot(deleteAutoSnapshot?.let({ args0 -> args0 }))
            .deleteWithInstance(deleteWithInstance?.let({ args0 -> args0 }))
            .diskName(diskName?.let({ args0 -> args0 }))
            .diskType(diskType?.let({ args0 -> args0 }))
            .dryRun(dryRun?.let({ args0 -> args0 }))
            .enableAutoSnapshot(enableAutoSnapshot?.let({ args0 -> args0 }))
            .enableAutomatedSnapshotPolicy(enableAutomatedSnapshotPolicy?.let({ args0 -> args0 }))
            .enableShared(enableShared?.let({ args0 -> args0 }))
            .encrypted(encrypted?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId?.let({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .operationLocks(
                operationLocks?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .paymentType(paymentType?.let({ args0 -> args0 }))
            .portable(portable?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .snapshotId(snapshotId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.let({ args0 -> args0 }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDisksPlainArgs].
 */
@PulumiTagMarker
public class GetDisksPlainArgsBuilder internal constructor() {
    private var additionalAttributes: List<String>? = null

    private var autoSnapshotPolicyId: String? = null

    private var availabilityZone: String? = null

    private var category: String? = null

    private var deleteAutoSnapshot: Boolean? = null

    private var deleteWithInstance: Boolean? = null

    private var diskName: String? = null

    private var diskType: String? = null

    private var dryRun: Boolean? = null

    private var enableAutoSnapshot: Boolean? = null

    private var enableAutomatedSnapshotPolicy: Boolean? = null

    private var enableShared: Boolean? = null

    private var encrypted: String? = null

    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var kmsKeyId: String? = null

    private var nameRegex: String? = null

    private var operationLocks: List<GetDisksOperationLock>? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var paymentType: String? = null

    private var portable: Boolean? = null

    private var resourceGroupId: String? = null

    private var snapshotId: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var type: String? = null

    private var zoneId: String? = null

    /**
     * @param value
     */
    @JvmName("ksnbfxeqehphswgo")
    public suspend fun additionalAttributes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.additionalAttributes = mapped
    }

    /**
     * @param values
     */
    @JvmName("tpfooywguwabyola")
    public suspend fun additionalAttributes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.additionalAttributes = mapped
    }

    /**
     * @param value
     */
    @JvmName("guridigbqdcodekk")
    public suspend fun autoSnapshotPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.autoSnapshotPolicyId = mapped
    }

    /**
     * @param value Availability zone of the disk.
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.122.0. New field 'zone_id'
      instead
  """,
    )
    @JvmName("odtfqpdpynixgnry")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availabilityZone = mapped
    }

    /**
     * @param value Disk category. Possible values: `cloud` (basic cloud disk), `cloud_efficiency` (ultra cloud disk), `ephemeral_ssd` (local SSD cloud disk), `cloud_ssd` (SSD cloud disk), and `cloud_essd` (ESSD cloud disk), `cloud_essd_entry`.
     */
    @JvmName("yichuyskitjgfxsw")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.category = mapped
    }

    /**
     * @param value
     */
    @JvmName("efbuonfjshyvoucf")
    public suspend fun deleteAutoSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.deleteAutoSnapshot = mapped
    }

    /**
     * @param value
     */
    @JvmName("swgovefsbqytmtex")
    public suspend fun deleteWithInstance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.deleteWithInstance = mapped
    }

    /**
     * @param value
     */
    @JvmName("nkllllnbohxvvtgi")
    public suspend fun diskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.diskName = mapped
    }

    /**
     * @param value
     */
    @JvmName("xupyughiexsybueh")
    public suspend fun diskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.diskType = mapped
    }

    /**
     * @param value
     */
    @JvmName("cowhsuicyiqjgwfm")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dryRun = mapped
    }

    /**
     * @param value
     */
    @JvmName("estxxifjubksyetp")
    public suspend fun enableAutoSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableAutoSnapshot = mapped
    }

    /**
     * @param value
     */
    @JvmName("enqotjahskkbefdv")
    public suspend fun enableAutomatedSnapshotPolicy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableAutomatedSnapshotPolicy = mapped
    }

    /**
     * @param value
     */
    @JvmName("xcnqebuabqgnnsfl")
    public suspend fun enableShared(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableShared = mapped
    }

    /**
     * @param value Indicate whether the disk is encrypted or not. Possible values: `on` and `off`.
     */
    @JvmName("uhwqekebjhpvdjtg")
    public suspend fun encrypted(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.encrypted = mapped
    }

    /**
     * @param value A list of disks IDs.
     */
    @JvmName("pyibajvptyjerodw")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of disks IDs.
     */
    @JvmName("cqssqswlvjfjuyvd")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Filter the results by the specified ECS instance ID.
     */
    @JvmName("xgwemexlmcauvfya")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value
     */
    @JvmName("ysqnveysfcqlgjdb")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.kmsKeyId = mapped
    }

    /**
     * @param value A regex string to filter results by disk name.
     */
    @JvmName("dctrirehvupmcyvc")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value
     */
    @JvmName("mfuftdfelqadpabu")
    public suspend fun operationLocks(`value`: List<GetDisksOperationLock>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.operationLocks = mapped
    }

    /**
     * @param argument
     */
    @JvmName("djvrvkppqfvbqqis")
    public suspend fun operationLocks(argument: List<suspend GetDisksOperationLockBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetDisksOperationLockBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.operationLocks = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nbfcagddqcyywdvn")
    public suspend fun operationLocks(vararg argument: suspend GetDisksOperationLockBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetDisksOperationLockBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.operationLocks = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pcherugubvqhyrif")
    public suspend fun operationLocks(argument: suspend GetDisksOperationLockBuilder.() -> Unit) {
        val toBeMapped = listOf(GetDisksOperationLockBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.operationLocks = mapped
    }

    /**
     * @param values
     */
    @JvmName("khftrwgxrlwemwlb")
    public suspend fun operationLocks(vararg values: GetDisksOperationLock) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.operationLocks = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("aopvigloshmdyvcy")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("cxiswnnhxjamdenb")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("vkdmyiksebeenlbu")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value
     */
    @JvmName("aqpmyquyfadopbak")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.paymentType = mapped
    }

    /**
     * @param value
     */
    @JvmName("bhawqblensdqjuyu")
    public suspend fun portable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.portable = mapped
    }

    /**
     * @param value The Id of resource group which the disk belongs.
     */
    @JvmName("xfpjicifvwfucfxa")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Snapshot used to create the disk. It is null if no snapshot is used to create the disk.
     */
    @JvmName("sekgmgkpjrscmqve")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.snapshotId = mapped
    }

    /**
     * @param value Current status. Possible values: `In_use`, `Available`, `Attaching`, `Detaching`, `Creating` and `ReIniting`.
     */
    @JvmName("fysvihcmvcghcfne")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A map of tags assigned to the disks. It must be in the format:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const disksDs = alicloud.ecs.getDisks({
     *     tags: {
     *         tagKey1: "tagValue1",
     *         tagKey2: "tagValue2",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * disks_ds = alicloud.ecs.get_disks(tags={
     *     "tagKey1": "tagValue1",
     *     "tagKey2": "tagValue2",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var disksDs = AliCloud.Ecs.GetDisks.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "tagKey1", "tagValue1" },
     *             { "tagKey2", "tagValue2" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ecs.GetDisks(ctx, &ecs.GetDisksArgs{
     * 			Tags: map[string]interface{}{
     * 				"tagKey1": "tagValue1",
     * 				"tagKey2": "tagValue2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetDisksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var disksDs = EcsFunctions.getDisks(GetDisksArgs.builder()
     *             .tags(Map.ofEntries(
     *                 Map.entry("tagKey1", "tagValue1"),
     *                 Map.entry("tagKey2", "tagValue2")
     *             ))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   disksDs:
     *     fn::invoke:
     *       Function: alicloud:ecs:getDisks
     *       Arguments:
     *         tags:
     *           tagKey1: tagValue1
     *           tagKey2: tagValue2
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("vbhnosmygusivptx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the disks. It must be in the format:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const disksDs = alicloud.ecs.getDisks({
     *     tags: {
     *         tagKey1: "tagValue1",
     *         tagKey2: "tagValue2",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * disks_ds = alicloud.ecs.get_disks(tags={
     *     "tagKey1": "tagValue1",
     *     "tagKey2": "tagValue2",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var disksDs = AliCloud.Ecs.GetDisks.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "tagKey1", "tagValue1" },
     *             { "tagKey2", "tagValue2" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ecs.GetDisks(ctx, &ecs.GetDisksArgs{
     * 			Tags: map[string]interface{}{
     * 				"tagKey1": "tagValue1",
     * 				"tagKey2": "tagValue2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetDisksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var disksDs = EcsFunctions.getDisks(GetDisksArgs.builder()
     *             .tags(Map.ofEntries(
     *                 Map.entry("tagKey1", "tagValue1"),
     *                 Map.entry("tagKey2", "tagValue2")
     *             ))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   disksDs:
     *     fn::invoke:
     *       Function: alicloud:ecs:getDisks
     *       Arguments:
     *         tags:
     *           tagKey1: tagValue1
     *           tagKey2: tagValue2
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("dljgdtwfltodtboc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Disk type. Possible values: `system` and `data`.
     */
    @Deprecated(
        message = """
  Field 'type' has been deprecated from provider version 1.122.0. New field 'disk_type' instead.
  """,
    )
    @JvmName("ajgsnywtabiujbcd")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("riwjlhmoaxdgqrjo")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetDisksPlainArgs = GetDisksPlainArgs(
        additionalAttributes = additionalAttributes,
        autoSnapshotPolicyId = autoSnapshotPolicyId,
        availabilityZone = availabilityZone,
        category = category,
        deleteAutoSnapshot = deleteAutoSnapshot,
        deleteWithInstance = deleteWithInstance,
        diskName = diskName,
        diskType = diskType,
        dryRun = dryRun,
        enableAutoSnapshot = enableAutoSnapshot,
        enableAutomatedSnapshotPolicy = enableAutomatedSnapshotPolicy,
        enableShared = enableShared,
        encrypted = encrypted,
        ids = ids,
        instanceId = instanceId,
        kmsKeyId = kmsKeyId,
        nameRegex = nameRegex,
        operationLocks = operationLocks,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        paymentType = paymentType,
        portable = portable,
        resourceGroupId = resourceGroupId,
        snapshotId = snapshotId,
        status = status,
        tags = tags,
        type = type,
        zoneId = zoneId,
    )
}
