@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetEcsDedicatedHostClustersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEcsDedicatedHostClusters.
 * @property dedicatedHostClusterIds The IDs of dedicated host clusters.
 * @property dedicatedHostClusterName The name of the dedicated host cluster.
 * @property ids A list of Dedicated Host Cluster IDs.
 * @property nameRegex A regex string to filter results by Dedicated Host Cluster name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property tags A mapping of tags to assign to the resource.
 * @property zoneId The zone ID of the dedicated host cluster.
 */
public data class GetEcsDedicatedHostClustersPlainArgs(
    public val dedicatedHostClusterIds: List<String>? = null,
    public val dedicatedHostClusterName: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val tags: Map<String, String>? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetEcsDedicatedHostClustersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetEcsDedicatedHostClustersPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetEcsDedicatedHostClustersPlainArgs.builder()
            .dedicatedHostClusterIds(dedicatedHostClusterIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .dedicatedHostClusterName(dedicatedHostClusterName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEcsDedicatedHostClustersPlainArgs].
 */
@PulumiTagMarker
public class GetEcsDedicatedHostClustersPlainArgsBuilder internal constructor() {
    private var dedicatedHostClusterIds: List<String>? = null

    private var dedicatedHostClusterName: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var tags: Map<String, String>? = null

    private var zoneId: String? = null

    /**
     * @param value The IDs of dedicated host clusters.
     */
    @JvmName("lbavvhsavdbxlxdh")
    public suspend fun dedicatedHostClusterIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dedicatedHostClusterIds = mapped
    }

    /**
     * @param values The IDs of dedicated host clusters.
     */
    @JvmName("isykwbystlcfovcg")
    public suspend fun dedicatedHostClusterIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dedicatedHostClusterIds = mapped
    }

    /**
     * @param value The name of the dedicated host cluster.
     */
    @JvmName("wkpcnovctfooavff")
    public suspend fun dedicatedHostClusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dedicatedHostClusterName = mapped
    }

    /**
     * @param value A list of Dedicated Host Cluster IDs.
     */
    @JvmName("wvbthkfblcpqoisr")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Dedicated Host Cluster IDs.
     */
    @JvmName("mgcckfqrrxiwdwkv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Dedicated Host Cluster name.
     */
    @JvmName("nkhjlvlslpctehpm")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("uqeyvlevaarcopox")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("beingiwwnyjtypgt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("wghonpmvpxaotcfi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value The zone ID of the dedicated host cluster.
     */
    @JvmName("wwltgdardtfvsvqy")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetEcsDedicatedHostClustersPlainArgs = GetEcsDedicatedHostClustersPlainArgs(
        dedicatedHostClusterIds = dedicatedHostClusterIds,
        dedicatedHostClusterName = dedicatedHostClusterName,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        tags = tags,
        zoneId = zoneId,
    )
}
