@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetEcsDeploymentSetsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEcsDeploymentSets.
 * @property deploymentSetName The name of the deployment set.
 * @property ids A list of Deployment Set IDs.
 * @property nameRegex A regex string to filter results by Deployment Set name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property strategy The deployment strategy. Valid values: `Availability`.
 */
public data class GetEcsDeploymentSetsPlainArgs(
    public val deploymentSetName: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val strategy: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetEcsDeploymentSetsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetEcsDeploymentSetsPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetEcsDeploymentSetsPlainArgs.builder()
            .deploymentSetName(deploymentSetName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .strategy(strategy?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEcsDeploymentSetsPlainArgs].
 */
@PulumiTagMarker
public class GetEcsDeploymentSetsPlainArgsBuilder internal constructor() {
    private var deploymentSetName: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var strategy: String? = null

    /**
     * @param value The name of the deployment set.
     */
    @JvmName("esjbrnumpfvkdity")
    public suspend fun deploymentSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.deploymentSetName = mapped
    }

    /**
     * @param value A list of Deployment Set IDs.
     */
    @JvmName("ouxdrsvijpqsjrry")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Deployment Set IDs.
     */
    @JvmName("eutnthsjeeoxlvyf")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Deployment Set name.
     */
    @JvmName("ahvrayqdxvjjmmtc")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("upjtjxgegikgkprq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The deployment strategy. Valid values: `Availability`.
     */
    @JvmName("hdyghbdpohebmcpb")
    public suspend fun strategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.strategy = mapped
    }

    internal fun build(): GetEcsDeploymentSetsPlainArgs = GetEcsDeploymentSetsPlainArgs(
        deploymentSetName = deploymentSetName,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        strategy = strategy,
    )
}
