@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetEcsDisksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEcsDisks.
 * @property additionalAttributes Other attribute values. Currently, only the incoming value of IOPS is supported, which means to query the IOPS upper limit of the current disk.
 * @property autoSnapshotPolicyId Query cloud disks based on the automatic snapshot policy ID.
 * @property availabilityZone Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead.
 * @property category Disk category. Valid values: `cloud`, `cloud_efficiency`, `cloud_essd`, `cloud_ssd`, `ephemeral_ssd`, `cloud_auto`, `cloud_essd_entry`.
 * @property deleteAutoSnapshot Indicates whether the automatic snapshot is deleted when the disk is released.
 * @property deleteWithInstance Indicates whether the disk is released together with the instance.
 * @property diskName The disk name.
 * @property diskType The disk type.
 * @property dryRun Specifies whether to check the validity of the request without actually making the request.request Default value: false. Valid values:
 * @property enableAutoSnapshot Indicates whether the automatic snapshot is deleted when the disk is released.
 * @property enableAutomatedSnapshotPolicy Whether the cloud disk has an automatic snapshot policy
 * @property enableShared Whether it is shared block storage.
 * @property encrypted Indicate whether the disk is encrypted or not. Possible values: `on` and `off`.
 * @property ids A list of Disk IDs.
 * @property instanceId Filter the results by the specified ECS instance ID.
 * @property kmsKeyId The kms key id.
 * @property nameRegex A regex string to filter results by Disk name.
 * @property operationLocks
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property paymentType Payment method for disk. Valid Values: `PayAsYouGo`, `Subscription`.
 * @property portable Whether the cloud disk or local disk supports uninstallation.
 * @property resourceGroupId The Id of resource group which the disk belongs.
 * @property snapshotId The source snapshot id.
 * @property status The status of disk.
 * @property tags A map of tags assigned to the disks.
 * @property type Field `type` has been deprecated from provider version 1.122.0. New field `disk_type` instead.
 * @property zoneId ID of the free zone to which the disk belongs.
 */
public data class GetEcsDisksPlainArgs(
    public val additionalAttributes: List<String>? = null,
    public val autoSnapshotPolicyId: String? = null,
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.122.0. New field 'zone_id'
      instead
  """,
    )
    public val availabilityZone: String? = null,
    public val category: String? = null,
    public val deleteAutoSnapshot: Boolean? = null,
    public val deleteWithInstance: Boolean? = null,
    public val diskName: String? = null,
    public val diskType: String? = null,
    public val dryRun: Boolean? = null,
    public val enableAutoSnapshot: Boolean? = null,
    public val enableAutomatedSnapshotPolicy: Boolean? = null,
    public val enableShared: Boolean? = null,
    public val encrypted: String? = null,
    public val ids: List<String>? = null,
    public val instanceId: String? = null,
    public val kmsKeyId: String? = null,
    public val nameRegex: String? = null,
    public val operationLocks: List<GetEcsDisksOperationLock>? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val paymentType: String? = null,
    public val portable: Boolean? = null,
    public val resourceGroupId: String? = null,
    public val snapshotId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    @Deprecated(
        message = """
  Field 'type' has been deprecated from provider version 1.122.0. New field 'disk_type' instead.
  """,
    )
    public val type: String? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetEcsDisksPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetEcsDisksPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetEcsDisksPlainArgs.builder()
            .additionalAttributes(additionalAttributes?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .autoSnapshotPolicyId(autoSnapshotPolicyId?.let({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.let({ args0 -> args0 }))
            .category(category?.let({ args0 -> args0 }))
            .deleteAutoSnapshot(deleteAutoSnapshot?.let({ args0 -> args0 }))
            .deleteWithInstance(deleteWithInstance?.let({ args0 -> args0 }))
            .diskName(diskName?.let({ args0 -> args0 }))
            .diskType(diskType?.let({ args0 -> args0 }))
            .dryRun(dryRun?.let({ args0 -> args0 }))
            .enableAutoSnapshot(enableAutoSnapshot?.let({ args0 -> args0 }))
            .enableAutomatedSnapshotPolicy(enableAutomatedSnapshotPolicy?.let({ args0 -> args0 }))
            .enableShared(enableShared?.let({ args0 -> args0 }))
            .encrypted(encrypted?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId?.let({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .operationLocks(
                operationLocks?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .paymentType(paymentType?.let({ args0 -> args0 }))
            .portable(portable?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .snapshotId(snapshotId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.let({ args0 -> args0 }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEcsDisksPlainArgs].
 */
@PulumiTagMarker
public class GetEcsDisksPlainArgsBuilder internal constructor() {
    private var additionalAttributes: List<String>? = null

    private var autoSnapshotPolicyId: String? = null

    private var availabilityZone: String? = null

    private var category: String? = null

    private var deleteAutoSnapshot: Boolean? = null

    private var deleteWithInstance: Boolean? = null

    private var diskName: String? = null

    private var diskType: String? = null

    private var dryRun: Boolean? = null

    private var enableAutoSnapshot: Boolean? = null

    private var enableAutomatedSnapshotPolicy: Boolean? = null

    private var enableShared: Boolean? = null

    private var encrypted: String? = null

    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var kmsKeyId: String? = null

    private var nameRegex: String? = null

    private var operationLocks: List<GetEcsDisksOperationLock>? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var paymentType: String? = null

    private var portable: Boolean? = null

    private var resourceGroupId: String? = null

    private var snapshotId: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var type: String? = null

    private var zoneId: String? = null

    /**
     * @param value Other attribute values. Currently, only the incoming value of IOPS is supported, which means to query the IOPS upper limit of the current disk.
     */
    @JvmName("gmfhwlmecklbhdet")
    public suspend fun additionalAttributes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.additionalAttributes = mapped
    }

    /**
     * @param values Other attribute values. Currently, only the incoming value of IOPS is supported, which means to query the IOPS upper limit of the current disk.
     */
    @JvmName("toxaosditfqnesgu")
    public suspend fun additionalAttributes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.additionalAttributes = mapped
    }

    /**
     * @param value Query cloud disks based on the automatic snapshot policy ID.
     */
    @JvmName("tcknylvuavpnnmnu")
    public suspend fun autoSnapshotPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.autoSnapshotPolicyId = mapped
    }

    /**
     * @param value Field `availability_zone` has been deprecated from provider version 1.122.0. New field `zone_id` instead.
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from provider version 1.122.0. New field 'zone_id'
      instead
  """,
    )
    @JvmName("kstuvkmcgdbhsmjn")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availabilityZone = mapped
    }

    /**
     * @param value Disk category. Valid values: `cloud`, `cloud_efficiency`, `cloud_essd`, `cloud_ssd`, `ephemeral_ssd`, `cloud_auto`, `cloud_essd_entry`.
     */
    @JvmName("yqjjhjbpaohfbeci")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.category = mapped
    }

    /**
     * @param value Indicates whether the automatic snapshot is deleted when the disk is released.
     */
    @JvmName("mfnqahilfprrlqeo")
    public suspend fun deleteAutoSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.deleteAutoSnapshot = mapped
    }

    /**
     * @param value Indicates whether the disk is released together with the instance.
     */
    @JvmName("blsdbiskhllhcnox")
    public suspend fun deleteWithInstance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.deleteWithInstance = mapped
    }

    /**
     * @param value The disk name.
     */
    @JvmName("pfljriifesheqxpf")
    public suspend fun diskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.diskName = mapped
    }

    /**
     * @param value The disk type.
     */
    @JvmName("sjvefluvlojppkpc")
    public suspend fun diskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.diskType = mapped
    }

    /**
     * @param value Specifies whether to check the validity of the request without actually making the request.request Default value: false. Valid values:
     */
    @JvmName("dpygumbffxuqgpnf")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dryRun = mapped
    }

    /**
     * @param value Indicates whether the automatic snapshot is deleted when the disk is released.
     */
    @JvmName("vkchikimvhpijoju")
    public suspend fun enableAutoSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableAutoSnapshot = mapped
    }

    /**
     * @param value Whether the cloud disk has an automatic snapshot policy
     */
    @JvmName("hxkqtrvcccsawsyj")
    public suspend fun enableAutomatedSnapshotPolicy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableAutomatedSnapshotPolicy = mapped
    }

    /**
     * @param value Whether it is shared block storage.
     */
    @JvmName("wmcyfhnidujbtfup")
    public suspend fun enableShared(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableShared = mapped
    }

    /**
     * @param value Indicate whether the disk is encrypted or not. Possible values: `on` and `off`.
     */
    @JvmName("xvxxkytfbuiwnqdv")
    public suspend fun encrypted(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.encrypted = mapped
    }

    /**
     * @param value A list of Disk IDs.
     */
    @JvmName("qvduvodpaphtdslu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Disk IDs.
     */
    @JvmName("hskwekgwyhnnqohn")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Filter the results by the specified ECS instance ID.
     */
    @JvmName("udrfnhjkonagkwri")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value The kms key id.
     */
    @JvmName("ioaqggkexfuuvhxk")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.kmsKeyId = mapped
    }

    /**
     * @param value A regex string to filter results by Disk name.
     */
    @JvmName("ojosgdlqgyqjtyrs")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value
     */
    @JvmName("mrqbknoflbsgtlci")
    public suspend fun operationLocks(`value`: List<GetEcsDisksOperationLock>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.operationLocks = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cjraqfmyeeoglwlc")
    public suspend fun operationLocks(argument: List<suspend GetEcsDisksOperationLockBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetEcsDisksOperationLockBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.operationLocks = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ssbfhafjqaxlnrnp")
    public suspend fun operationLocks(vararg argument: suspend GetEcsDisksOperationLockBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetEcsDisksOperationLockBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.operationLocks = mapped
    }

    /**
     * @param argument
     */
    @JvmName("sfgtuqrbknpedfrj")
    public suspend fun operationLocks(argument: suspend GetEcsDisksOperationLockBuilder.() -> Unit) {
        val toBeMapped = listOf(GetEcsDisksOperationLockBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.operationLocks = mapped
    }

    /**
     * @param values
     */
    @JvmName("poxrjjioekspirev")
    public suspend fun operationLocks(vararg values: GetEcsDisksOperationLock) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.operationLocks = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ffugsnjvwpwcdtfx")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("yrsvfmtraxyjdbxr")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("mnyjoeqvkjsgryel")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value Payment method for disk. Valid Values: `PayAsYouGo`, `Subscription`.
     */
    @JvmName("tqspdvtnocdiglws")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.paymentType = mapped
    }

    /**
     * @param value Whether the cloud disk or local disk supports uninstallation.
     */
    @JvmName("mkfaomrewauwpydi")
    public suspend fun portable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.portable = mapped
    }

    /**
     * @param value The Id of resource group which the disk belongs.
     */
    @JvmName("yfynoqcfnwrrllch")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The source snapshot id.
     */
    @JvmName("ogdeecqxqpnvwvav")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.snapshotId = mapped
    }

    /**
     * @param value The status of disk.
     */
    @JvmName("kobgdsiwgvvqxbxj")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A map of tags assigned to the disks.
     */
    @JvmName("bcnrdolnkjromldl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the disks.
     */
    @JvmName("ekftplxxjbdjsxvm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Field `type` has been deprecated from provider version 1.122.0. New field `disk_type` instead.
     */
    @Deprecated(
        message = """
  Field 'type' has been deprecated from provider version 1.122.0. New field 'disk_type' instead.
  """,
    )
    @JvmName("wwbbyxuhmwohxind")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value ID of the free zone to which the disk belongs.
     */
    @JvmName("vdvpjmvyjnguakhn")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetEcsDisksPlainArgs = GetEcsDisksPlainArgs(
        additionalAttributes = additionalAttributes,
        autoSnapshotPolicyId = autoSnapshotPolicyId,
        availabilityZone = availabilityZone,
        category = category,
        deleteAutoSnapshot = deleteAutoSnapshot,
        deleteWithInstance = deleteWithInstance,
        diskName = diskName,
        diskType = diskType,
        dryRun = dryRun,
        enableAutoSnapshot = enableAutoSnapshot,
        enableAutomatedSnapshotPolicy = enableAutomatedSnapshotPolicy,
        enableShared = enableShared,
        encrypted = encrypted,
        ids = ids,
        instanceId = instanceId,
        kmsKeyId = kmsKeyId,
        nameRegex = nameRegex,
        operationLocks = operationLocks,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        paymentType = paymentType,
        portable = portable,
        resourceGroupId = resourceGroupId,
        snapshotId = snapshotId,
        status = status,
        tags = tags,
        type = type,
        zoneId = zoneId,
    )
}
