@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetEcsImageComponentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEcsImageComponents.
 * @property ids A list of Image Component IDs.
 * @property imageComponentName The name of the component.
 * @property nameRegex A regex string to filter results by Image Component name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property owner Mirror component type. Valid values: `SELF` or `ALIYUN`. Possible values:
 * - SELF: The custom image component you created.
 * - ALIYUN: System components provided by Alibaba Cloud.
 * @property resourceGroupId The ID of the resource group.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetEcsImageComponentsPlainArgs(
    public val ids: List<String>? = null,
    public val imageComponentName: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val owner: String? = null,
    public val resourceGroupId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetEcsImageComponentsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetEcsImageComponentsPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetEcsImageComponentsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .imageComponentName(imageComponentName?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .owner(owner?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetEcsImageComponentsPlainArgs].
 */
@PulumiTagMarker
public class GetEcsImageComponentsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var imageComponentName: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var owner: String? = null

    private var resourceGroupId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value A list of Image Component IDs.
     */
    @JvmName("uhrtmtnhacktissq")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Image Component IDs.
     */
    @JvmName("fbxfbexhihugogbn")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The name of the component.
     */
    @JvmName("lqejcdjgoxppqpds")
    public suspend fun imageComponentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.imageComponentName = mapped
    }

    /**
     * @param value A regex string to filter results by Image Component name.
     */
    @JvmName("akrebqpnvqydmjrp")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("gdstuhkvilxinrhp")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Mirror component type. Valid values: `SELF` or `ALIYUN`. Possible values:
     * - SELF: The custom image component you created.
     * - ALIYUN: System components provided by Alibaba Cloud.
     */
    @JvmName("nlhmhwhtjrtkawgk")
    public suspend fun owner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.owner = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("rskknlnsrrakkkxe")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("qnsjemmuxasrjoyr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("shjcsworqagrkbgm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetEcsImageComponentsPlainArgs = GetEcsImageComponentsPlainArgs(
        ids = ids,
        imageComponentName = imageComponentName,
        nameRegex = nameRegex,
        outputFile = outputFile,
        owner = owner,
        resourceGroupId = resourceGroupId,
        tags = tags,
    )
}
