@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetEcsInvocationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEcsInvocations.
 * @property commandId The execution ID of the command.
 * @property contentEncoding The encoding mode of the CommandContent and Output response parameters. Valid values: `PlainText`, `Base64`.
 * @property ids A list of Invocation IDs.
 * @property invokeStatus The overall execution state of the command. The value of this parameter depends on the execution states on all the involved instances. Valid values: `Running`, `Finished`, `Failed`, `PartialFailed`, `Stopped`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 */
public data class GetEcsInvocationsPlainArgs(
    public val commandId: String? = null,
    public val contentEncoding: String? = null,
    public val ids: List<String>? = null,
    public val invokeStatus: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetEcsInvocationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetEcsInvocationsPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetEcsInvocationsPlainArgs.builder()
            .commandId(commandId?.let({ args0 -> args0 }))
            .contentEncoding(contentEncoding?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .invokeStatus(invokeStatus?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEcsInvocationsPlainArgs].
 */
@PulumiTagMarker
public class GetEcsInvocationsPlainArgsBuilder internal constructor() {
    private var commandId: String? = null

    private var contentEncoding: String? = null

    private var ids: List<String>? = null

    private var invokeStatus: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    /**
     * @param value The execution ID of the command.
     */
    @JvmName("stdociwgnjdsfycv")
    public suspend fun commandId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.commandId = mapped
    }

    /**
     * @param value The encoding mode of the CommandContent and Output response parameters. Valid values: `PlainText`, `Base64`.
     */
    @JvmName("lvnobgxuenwynpfd")
    public suspend fun contentEncoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.contentEncoding = mapped
    }

    /**
     * @param value A list of Invocation IDs.
     */
    @JvmName("mlpwiitxxedomfbk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Invocation IDs.
     */
    @JvmName("tvacoomkvygtabbu")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The overall execution state of the command. The value of this parameter depends on the execution states on all the involved instances. Valid values: `Running`, `Finished`, `Failed`, `PartialFailed`, `Stopped`.
     */
    @JvmName("mubqrdbbpucrgnos")
    public suspend fun invokeStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.invokeStatus = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("sqkayhwafyhvpnqb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("braqwshgequgkcid")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("ekohixilpyqjeual")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    internal fun build(): GetEcsInvocationsPlainArgs = GetEcsInvocationsPlainArgs(
        commandId = commandId,
        contentEncoding = contentEncoding,
        ids = ids,
        invokeStatus = invokeStatus,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
    )
}
