@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetEcsKeyPairsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEcsKeyPairs.
 * @property fingerPrint The finger print of the key pair.
 * @property ids A list of Key Pair IDs.
 * @property nameRegex A regex string to filter results by Key Pair name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The resource group Id.
 * @property tags
 */
public data class GetEcsKeyPairsPlainArgs(
    public val fingerPrint: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetEcsKeyPairsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetEcsKeyPairsPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetEcsKeyPairsPlainArgs.builder()
            .fingerPrint(fingerPrint?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetEcsKeyPairsPlainArgs].
 */
@PulumiTagMarker
public class GetEcsKeyPairsPlainArgsBuilder internal constructor() {
    private var fingerPrint: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value The finger print of the key pair.
     */
    @JvmName("tpbukjpweilphnwr")
    public suspend fun fingerPrint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.fingerPrint = mapped
    }

    /**
     * @param value A list of Key Pair IDs.
     */
    @JvmName("ydvcpuaokffncumg")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Key Pair IDs.
     */
    @JvmName("dsetmplxsyumksyx")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Key Pair name.
     */
    @JvmName("xiwlovqbuxgidllq")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("djbhqhtwxqavqxry")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The resource group Id.
     */
    @JvmName("igdoglqoygxwrctx")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("vhrxdodvrrinjoaq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("crkvxrxcbnbtirdb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetEcsKeyPairsPlainArgs = GetEcsKeyPairsPlainArgs(
        fingerPrint = fingerPrint,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        tags = tags,
    )
}
