@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetEcsLaunchTemplatesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEcsLaunchTemplates.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Launch Template IDs.
 * @property launchTemplateName The Launch Template Name.
 * @property nameRegex A regex string to filter results by Launch Template name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property templateResourceGroupId The template resource group id.
 * @property templateTags
 */
public data class GetEcsLaunchTemplatesPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val launchTemplateName: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val templateResourceGroupId: String? = null,
    public val templateTags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetEcsLaunchTemplatesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetEcsLaunchTemplatesPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetEcsLaunchTemplatesPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .launchTemplateName(launchTemplateName?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .templateResourceGroupId(templateResourceGroupId?.let({ args0 -> args0 }))
            .templateTags(
                templateTags?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GetEcsLaunchTemplatesPlainArgs].
 */
@PulumiTagMarker
public class GetEcsLaunchTemplatesPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var launchTemplateName: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var templateResourceGroupId: String? = null

    private var templateTags: Map<String, String>? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("emexevhpsitgpgcm")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Launch Template IDs.
     */
    @JvmName("jdfntrfmbsxqqjhc")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Launch Template IDs.
     */
    @JvmName("tvywfbnqexpxnsde")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The Launch Template Name.
     */
    @JvmName("gmuygwuokioinwyo")
    public suspend fun launchTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.launchTemplateName = mapped
    }

    /**
     * @param value A regex string to filter results by Launch Template name.
     */
    @JvmName("qxtrhhomwqmrklml")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("btucwgewojsvjghq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The template resource group id.
     */
    @JvmName("nisipupjvlyigsiy")
    public suspend fun templateResourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.templateResourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("tdpavfbhytptefqc")
    public suspend fun templateTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.templateTags = mapped
    }

    /**
     * @param values
     */
    @JvmName("ywhoumeocimqlpsv")
    public fun templateTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.templateTags = mapped
    }

    internal fun build(): GetEcsLaunchTemplatesPlainArgs = GetEcsLaunchTemplatesPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        launchTemplateName = launchTemplateName,
        nameRegex = nameRegex,
        outputFile = outputFile,
        templateResourceGroupId = templateResourceGroupId,
        templateTags = templateTags,
    )
}
