@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetEcsNetworkInterfacePermissionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEcsNetworkInterfacePermissions.
 * @property ids A list of Network Interface Permission IDs.
 * @property networkInterfaceId The ID of the network interface.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property status The Status of the Network Interface Permissions. Valid values: `Granted`, `Pending`, `Revoked`, `Revoking`.
 */
public data class GetEcsNetworkInterfacePermissionsPlainArgs(
    public val ids: List<String>? = null,
    public val networkInterfaceId: String,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetEcsNetworkInterfacePermissionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetEcsNetworkInterfacePermissionsPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetEcsNetworkInterfacePermissionsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .networkInterfaceId(networkInterfaceId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEcsNetworkInterfacePermissionsPlainArgs].
 */
@PulumiTagMarker
public class GetEcsNetworkInterfacePermissionsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var networkInterfaceId: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var status: String? = null

    /**
     * @param value A list of Network Interface Permission IDs.
     */
    @JvmName("ftwiewylomfttpbk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Network Interface Permission IDs.
     */
    @JvmName("oxjqcqftyojlvsqh")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the network interface.
     */
    @JvmName("llfrpgrrtbsqtopa")
    public suspend fun networkInterfaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jqluyhbgdyggkccm")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("jigrfqgyrfapwnte")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("alxmpebiqdnagske")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The Status of the Network Interface Permissions. Valid values: `Granted`, `Pending`, `Revoked`, `Revoking`.
     */
    @JvmName("qnlobedfaiwnrkyi")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetEcsNetworkInterfacePermissionsPlainArgs =
        GetEcsNetworkInterfacePermissionsPlainArgs(
            ids = ids,
            networkInterfaceId = networkInterfaceId ?: throw PulumiNullFieldException("networkInterfaceId"),
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            status = status,
        )
}
