@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetEcsNetworkInterfacesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEcsNetworkInterfaces.
 * @property ids A list of Network Interface IDs.
 * @property instanceId The instance id.
 * @property name Field `name` has been deprecated from provider version 1.123.1. New field `network_interface_name` instead
 * @property nameRegex A regex string to filter results by Network Interface name.
 * @property networkInterfaceName The network interface name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property primaryIpAddress The primary private IP address of the ENI.
 * @property privateIp Field `private_ip` has been deprecated from provider version 1.123.1. New field `primary_ip_address` instead
 * @property resourceGroupId The resource group id.
 * @property securityGroupId The security group id.
 * @property serviceManaged Whether the user of the elastic network card is a cloud product or a virtual vendor.
 * @property status The status of ENI. Valid Values: `Attaching`, `Available`, `CreateFailed`, `Creating`, `Deleting`, `Detaching`, `InUse`, `Linked`, `Linking`, `Unlinking`.
 * @property tags A map of tags assigned to ENIs.
 * @property type The type of ENI. Valid Values: `Primary`, `Secondary`.
 * @property vpcId The vpc id.
 * @property vswitchId The vswitch id.
 */
public data class GetEcsNetworkInterfacesPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name'
      instead
  """,
    )
    public val name: String? = null,
    public val nameRegex: String? = null,
    public val networkInterfaceName: String? = null,
    public val outputFile: String? = null,
    public val primaryIpAddress: String? = null,
    @Deprecated(
        message = """
  Field 'private_ip' has been deprecated from provider version 1.123.1. New field
      'primary_ip_address' instead
  """,
    )
    public val privateIp: String? = null,
    public val resourceGroupId: String? = null,
    public val securityGroupId: String? = null,
    public val serviceManaged: Boolean? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String? = null,
    public val vpcId: String? = null,
    public val vswitchId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetEcsNetworkInterfacesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetEcsNetworkInterfacesPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetEcsNetworkInterfacesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .networkInterfaceName(networkInterfaceName?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .primaryIpAddress(primaryIpAddress?.let({ args0 -> args0 }))
            .privateIp(privateIp?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.let({ args0 -> args0 }))
            .serviceManaged(serviceManaged?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.let({ args0 -> args0 }))
            .vpcId(vpcId?.let({ args0 -> args0 }))
            .vswitchId(vswitchId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEcsNetworkInterfacesPlainArgs].
 */
@PulumiTagMarker
public class GetEcsNetworkInterfacesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var name: String? = null

    private var nameRegex: String? = null

    private var networkInterfaceName: String? = null

    private var outputFile: String? = null

    private var primaryIpAddress: String? = null

    private var privateIp: String? = null

    private var resourceGroupId: String? = null

    private var securityGroupId: String? = null

    private var serviceManaged: Boolean? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var type: String? = null

    private var vpcId: String? = null

    private var vswitchId: String? = null

    /**
     * @param value A list of Network Interface IDs.
     */
    @JvmName("cqnvxuiggurbrqah")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Network Interface IDs.
     */
    @JvmName("wcospkponxkvyslh")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The instance id.
     */
    @JvmName("utcypgmtuioreumv")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value Field `name` has been deprecated from provider version 1.123.1. New field `network_interface_name` instead
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name'
      instead
  """,
    )
    @JvmName("nqcvrhqcuusxqmcx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value A regex string to filter results by Network Interface name.
     */
    @JvmName("hruhpelsgrsuxbot")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The network interface name.
     */
    @JvmName("ywuqvuideblmhdxv")
    public suspend fun networkInterfaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.networkInterfaceName = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("tmngndsserjotxri")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The primary private IP address of the ENI.
     */
    @JvmName("qwusqosgvwruupdc")
    public suspend fun primaryIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.primaryIpAddress = mapped
    }

    /**
     * @param value Field `private_ip` has been deprecated from provider version 1.123.1. New field `primary_ip_address` instead
     */
    @Deprecated(
        message = """
  Field 'private_ip' has been deprecated from provider version 1.123.1. New field
      'primary_ip_address' instead
  """,
    )
    @JvmName("wmrlivrahhclkkho")
    public suspend fun privateIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.privateIp = mapped
    }

    /**
     * @param value The resource group id.
     */
    @JvmName("sqbgwbvgcwfixclw")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The security group id.
     */
    @JvmName("ivlohflagoksvxhl")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.securityGroupId = mapped
    }

    /**
     * @param value Whether the user of the elastic network card is a cloud product or a virtual vendor.
     */
    @JvmName("mrxiaxnqlkaihyhg")
    public suspend fun serviceManaged(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serviceManaged = mapped
    }

    /**
     * @param value The status of ENI. Valid Values: `Attaching`, `Available`, `CreateFailed`, `Creating`, `Deleting`, `Detaching`, `InUse`, `Linked`, `Linking`, `Unlinking`.
     */
    @JvmName("hrjrqvlhcxoljfwj")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A map of tags assigned to ENIs.
     */
    @JvmName("mrjwnhwevplfevng")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to ENIs.
     */
    @JvmName("ecmwwgjtpgfvyrmk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value The type of ENI. Valid Values: `Primary`, `Secondary`.
     */
    @JvmName("fjaunecaodqmvbpl")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value The vpc id.
     */
    @JvmName("odtvmkxwvmjfrjgo")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    /**
     * @param value The vswitch id.
     */
    @JvmName("huggoabtheodbiwy")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vswitchId = mapped
    }

    internal fun build(): GetEcsNetworkInterfacesPlainArgs = GetEcsNetworkInterfacesPlainArgs(
        ids = ids,
        instanceId = instanceId,
        name = name,
        nameRegex = nameRegex,
        networkInterfaceName = networkInterfaceName,
        outputFile = outputFile,
        primaryIpAddress = primaryIpAddress,
        privateIp = privateIp,
        resourceGroupId = resourceGroupId,
        securityGroupId = securityGroupId,
        serviceManaged = serviceManaged,
        status = status,
        tags = tags,
        type = type,
        vpcId = vpcId,
        vswitchId = vswitchId,
    )
}
