@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetEcsPrefixListsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEcsPrefixLists.
 * @property addressFamily The address family of the prefix list. Valid values: `IPv4`,`IPv6`. This parameter is empty by default, which indicates that all prefix lists are to be queried.
 * @property enableDetails
 * @property ids A list of Prefix List IDs.
 * @property nameRegex A regex string to filter results by `prefix_list_name`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetEcsPrefixListsPlainArgs(
    public val addressFamily: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetEcsPrefixListsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetEcsPrefixListsPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetEcsPrefixListsPlainArgs.builder()
            .addressFamily(addressFamily?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEcsPrefixListsPlainArgs].
 */
@PulumiTagMarker
public class GetEcsPrefixListsPlainArgsBuilder internal constructor() {
    private var addressFamily: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The address family of the prefix list. Valid values: `IPv4`,`IPv6`. This parameter is empty by default, which indicates that all prefix lists are to be queried.
     */
    @JvmName("nxjbbcvijrevfdfg")
    public suspend fun addressFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.addressFamily = mapped
    }

    /**
     * @param value
     */
    @JvmName("wxlepjmhxothfnbf")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Prefix List IDs.
     */
    @JvmName("myeohoaxdxiowlit")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Prefix List IDs.
     */
    @JvmName("qtgiwlspmwwfsdyv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by `prefix_list_name`.
     */
    @JvmName("dyvveglwbfythagm")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("tgldirhhamqioqtp")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetEcsPrefixListsPlainArgs = GetEcsPrefixListsPlainArgs(
        addressFamily = addressFamily,
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
