@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetEcsSnapshotGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEcsSnapshotGroups.
 * @property ids A list of Snapshot Group IDs.
 * @property instanceId The ID of the instance.
 * @property nameRegex A regex string to filter results by Snapshot Group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property snapshotGroupName The name of the snapshot-consistent group.
 * @property status The state of snapshot-consistent group. Valid Values: `accomplished`, `failed` and `progressing`.
 * @property tags A mapping of tags to assign to the snapshot group.
 */
public data class GetEcsSnapshotGroupsPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val snapshotGroupName: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetEcsSnapshotGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetEcsSnapshotGroupsPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetEcsSnapshotGroupsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .snapshotGroupName(snapshotGroupName?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetEcsSnapshotGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetEcsSnapshotGroupsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var snapshotGroupName: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value A list of Snapshot Group IDs.
     */
    @JvmName("twpyqyqkdkgctjld")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Snapshot Group IDs.
     */
    @JvmName("umemhnanvyfcutyg")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("phmkkkvoyeqwmasi")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by Snapshot Group name.
     */
    @JvmName("nadjwqswcgiirnug")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qydunqtyusxneehl")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The name of the snapshot-consistent group.
     */
    @JvmName("qwcmxvlywqwvoolc")
    public suspend fun snapshotGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.snapshotGroupName = mapped
    }

    /**
     * @param value The state of snapshot-consistent group. Valid Values: `accomplished`, `failed` and `progressing`.
     */
    @JvmName("qabysppgwjlepkkq")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the snapshot group.
     */
    @JvmName("wiaecffbxhdkunsd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the snapshot group.
     */
    @JvmName("fflswxeanckpxmgo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetEcsSnapshotGroupsPlainArgs = GetEcsSnapshotGroupsPlainArgs(
        ids = ids,
        instanceId = instanceId,
        nameRegex = nameRegex,
        outputFile = outputFile,
        snapshotGroupName = snapshotGroupName,
        status = status,
        tags = tags,
    )
}
