@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetEcsSnapshotsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEcsSnapshots.
 * @property category The category of the snapshot. Valid Values: `flash` and `standard`.
 * @property dryRun Specifies whether to check the validity of the request without actually making the request.
 * @property encrypted Specifies whether the snapshot is encrypted.
 * @property ids A list of Snapshot IDs.
 * @property kmsKeyId The kms key id.
 * @property nameRegex A regex string to filter results by Snapshot name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The resource group id.
 * @property snapshotLinkId The snapshot link id.
 * @property snapshotName The name of the snapshot.
 * @property snapshotType The type of the snapshot. Valid Values: `auto`, `user` and `all`. Default to: `all`.
 * @property sourceDiskType The type of the disk for which the snapshot was created. Valid Values: `System`, `Data`.
 * @property status The status of the snapshot. Valid Values: `accomplished`, `failed`, `progressing` and `all`.
 * @property tags A mapping of tags to assign to the snapshot.
 * @property type
 * @property usage A resource type that has a reference relationship. Valid Values: `image`, `disk`, `image_disk` and `none`.
 */
public data class GetEcsSnapshotsPlainArgs(
    public val category: String? = null,
    public val dryRun: Boolean? = null,
    public val encrypted: Boolean? = null,
    public val ids: List<String>? = null,
    public val kmsKeyId: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val snapshotLinkId: String? = null,
    public val snapshotName: String? = null,
    public val snapshotType: String? = null,
    public val sourceDiskType: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String? = null,
    public val usage: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetEcsSnapshotsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetEcsSnapshotsPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetEcsSnapshotsPlainArgs.builder()
            .category(category?.let({ args0 -> args0 }))
            .dryRun(dryRun?.let({ args0 -> args0 }))
            .encrypted(encrypted?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .kmsKeyId(kmsKeyId?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .snapshotLinkId(snapshotLinkId?.let({ args0 -> args0 }))
            .snapshotName(snapshotName?.let({ args0 -> args0 }))
            .snapshotType(snapshotType?.let({ args0 -> args0 }))
            .sourceDiskType(sourceDiskType?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.let({ args0 -> args0 }))
            .usage(usage?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEcsSnapshotsPlainArgs].
 */
@PulumiTagMarker
public class GetEcsSnapshotsPlainArgsBuilder internal constructor() {
    private var category: String? = null

    private var dryRun: Boolean? = null

    private var encrypted: Boolean? = null

    private var ids: List<String>? = null

    private var kmsKeyId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var snapshotLinkId: String? = null

    private var snapshotName: String? = null

    private var snapshotType: String? = null

    private var sourceDiskType: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var type: String? = null

    private var usage: String? = null

    /**
     * @param value The category of the snapshot. Valid Values: `flash` and `standard`.
     */
    @JvmName("clgstdcsmvevxpcw")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.category = mapped
    }

    /**
     * @param value Specifies whether to check the validity of the request without actually making the request.
     */
    @JvmName("mdutnubxckskfnol")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dryRun = mapped
    }

    /**
     * @param value Specifies whether the snapshot is encrypted.
     */
    @JvmName("gsnxeldktwbixsfu")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.encrypted = mapped
    }

    /**
     * @param value A list of Snapshot IDs.
     */
    @JvmName("solsdatriwtvclto")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Snapshot IDs.
     */
    @JvmName("tmahaamdwsghbfag")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The kms key id.
     */
    @JvmName("pkwxnunhpmipgsxl")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.kmsKeyId = mapped
    }

    /**
     * @param value A regex string to filter results by Snapshot name.
     */
    @JvmName("icuidjcmgepltkvt")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qolucccpulasluwg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The resource group id.
     */
    @JvmName("qjxnjcerepasiage")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The snapshot link id.
     */
    @JvmName("esjynmocnmmgqgla")
    public suspend fun snapshotLinkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.snapshotLinkId = mapped
    }

    /**
     * @param value The name of the snapshot.
     */
    @JvmName("ubsdrbssymiwmwlw")
    public suspend fun snapshotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.snapshotName = mapped
    }

    /**
     * @param value The type of the snapshot. Valid Values: `auto`, `user` and `all`. Default to: `all`.
     */
    @JvmName("ivflxepgdsxavqce")
    public suspend fun snapshotType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.snapshotType = mapped
    }

    /**
     * @param value The type of the disk for which the snapshot was created. Valid Values: `System`, `Data`.
     */
    @JvmName("tmkmgukfemeyidub")
    public suspend fun sourceDiskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sourceDiskType = mapped
    }

    /**
     * @param value The status of the snapshot. Valid Values: `accomplished`, `failed`, `progressing` and `all`.
     */
    @JvmName("oqijtystgdfoirdi")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the snapshot.
     */
    @JvmName("ffpcupkgykfjpqxx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the snapshot.
     */
    @JvmName("rlskoxsfnyufsjos")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("gaifuxsckvyelwmh")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value A resource type that has a reference relationship. Valid Values: `image`, `disk`, `image_disk` and `none`.
     */
    @JvmName("qjfefmngwfgbhogo")
    public suspend fun usage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.usage = mapped
    }

    internal fun build(): GetEcsSnapshotsPlainArgs = GetEcsSnapshotsPlainArgs(
        category = category,
        dryRun = dryRun,
        encrypted = encrypted,
        ids = ids,
        kmsKeyId = kmsKeyId,
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        snapshotLinkId = snapshotLinkId,
        snapshotName = snapshotName,
        snapshotType = snapshotType,
        sourceDiskType = sourceDiskType,
        status = status,
        tags = tags,
        type = type,
        usage = usage,
    )
}
