@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetEipsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEips.
 * @property addressName
 * @property associatedInstanceId
 * @property associatedInstanceType
 * @property dryRun
 * @property enableDetails
 * @property ids A list of EIP IDs.
 * @property includeReservationData
 * @property ipAddress Public IP Address of the the EIP.
 * @property ipAddresses A list of EIP public IP addresses.
 * @property isp
 * @property lockReason
 * @property nameRegex
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property paymentType
 * @property resourceGroupId The Id of resource group which the eips belongs.
 * @property segmentInstanceId
 * @property status EIP status. Possible values are: `Associating`, `Unassociating`, `InUse` and `Available`.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetEipsPlainArgs(
    public val addressName: String? = null,
    public val associatedInstanceId: String? = null,
    public val associatedInstanceType: String? = null,
    public val dryRun: Boolean? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val includeReservationData: Boolean? = null,
    public val ipAddress: String? = null,
    @Deprecated(
        message = """
  Field 'ip_addresses' has been deprecated from provider version 1.126.0 and it will be removed in
      the future version. Please use the new attribute 'ip_address' instead.
  """,
    )
    public val ipAddresses: List<String>? = null,
    public val isp: String? = null,
    public val lockReason: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val paymentType: String? = null,
    public val resourceGroupId: String? = null,
    public val segmentInstanceId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetEipsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetEipsPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetEipsPlainArgs.builder()
            .addressName(addressName?.let({ args0 -> args0 }))
            .associatedInstanceId(associatedInstanceId?.let({ args0 -> args0 }))
            .associatedInstanceType(associatedInstanceType?.let({ args0 -> args0 }))
            .dryRun(dryRun?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .includeReservationData(includeReservationData?.let({ args0 -> args0 }))
            .ipAddress(ipAddress?.let({ args0 -> args0 }))
            .ipAddresses(ipAddresses?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .isp(isp?.let({ args0 -> args0 }))
            .lockReason(lockReason?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .paymentType(paymentType?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .segmentInstanceId(segmentInstanceId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetEipsPlainArgs].
 */
@PulumiTagMarker
public class GetEipsPlainArgsBuilder internal constructor() {
    private var addressName: String? = null

    private var associatedInstanceId: String? = null

    private var associatedInstanceType: String? = null

    private var dryRun: Boolean? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var includeReservationData: Boolean? = null

    private var ipAddress: String? = null

    private var ipAddresses: List<String>? = null

    private var isp: String? = null

    private var lockReason: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var paymentType: String? = null

    private var resourceGroupId: String? = null

    private var segmentInstanceId: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value
     */
    @JvmName("qafbusxkqimcevhj")
    public suspend fun addressName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.addressName = mapped
    }

    /**
     * @param value
     */
    @JvmName("ftyswhulvqjqiwof")
    public suspend fun associatedInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.associatedInstanceId = mapped
    }

    /**
     * @param value
     */
    @JvmName("crvdotoqowepaynf")
    public suspend fun associatedInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.associatedInstanceType = mapped
    }

    /**
     * @param value
     */
    @JvmName("haqbjlcysonwrext")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dryRun = mapped
    }

    /**
     * @param value
     */
    @JvmName("ievemstkbnqdyqsj")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of EIP IDs.
     */
    @JvmName("rsehjlhewkfuciyf")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of EIP IDs.
     */
    @JvmName("dhvjyedsvwtsvopc")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("djgwhxigcsktolvd")
    public suspend fun includeReservationData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeReservationData = mapped
    }

    /**
     * @param value Public IP Address of the the EIP.
     */
    @JvmName("tsfgkwmpxyjdmdva")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ipAddress = mapped
    }

    /**
     * @param value A list of EIP public IP addresses.
     */
    @Deprecated(
        message = """
  Field 'ip_addresses' has been deprecated from provider version 1.126.0 and it will be removed in
      the future version. Please use the new attribute 'ip_address' instead.
  """,
    )
    @JvmName("usugwpbexnmaofvf")
    public suspend fun ipAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ipAddresses = mapped
    }

    /**
     * @param values A list of EIP public IP addresses.
     */
    @Deprecated(
        message = """
  Field 'ip_addresses' has been deprecated from provider version 1.126.0 and it will be removed in
      the future version. Please use the new attribute 'ip_address' instead.
  """,
    )
    @JvmName("jykegpgsypmuhtye")
    public suspend fun ipAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ipAddresses = mapped
    }

    /**
     * @param value
     */
    @JvmName("xitnslkwdqgedjwg")
    public suspend fun isp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.isp = mapped
    }

    /**
     * @param value
     */
    @JvmName("ajimjdcimaoelffd")
    public suspend fun lockReason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lockReason = mapped
    }

    /**
     * @param value
     */
    @JvmName("rpxyhphmeerytsqe")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("biqolwwmtbqkpdwv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("xdstxfxijwbetbpd")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.paymentType = mapped
    }

    /**
     * @param value The Id of resource group which the eips belongs.
     */
    @JvmName("tlqtqdfxqjctvdew")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("hnkukvbkyjvcuscp")
    public suspend fun segmentInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.segmentInstanceId = mapped
    }

    /**
     * @param value EIP status. Possible values are: `Associating`, `Unassociating`, `InUse` and `Available`.
     */
    @JvmName("jbqlrmvpatfyejnu")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("ajfryxkdrkdhvuqb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("dagvsiiojannkgxn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetEipsPlainArgs = GetEipsPlainArgs(
        addressName = addressName,
        associatedInstanceId = associatedInstanceId,
        associatedInstanceType = associatedInstanceType,
        dryRun = dryRun,
        enableDetails = enableDetails,
        ids = ids,
        includeReservationData = includeReservationData,
        ipAddress = ipAddress,
        ipAddresses = ipAddresses,
        isp = isp,
        lockReason = lockReason,
        nameRegex = nameRegex,
        outputFile = outputFile,
        paymentType = paymentType,
        resourceGroupId = resourceGroupId,
        segmentInstanceId = segmentInstanceId,
        status = status,
        tags = tags,
    )
}
