@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetElasticityAssurancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getElasticityAssurances.
 * @property ids A list of Elasticity Assurance IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property privatePoolOptionsIds The ID of the elastic protection service.
 * @property resourceGroupId The ID of the resource group.
 * @property status The status of flexible guarantee services. Possible values: `All`, `Preparing`, `Prepared`, `Active`, `Released`.
 * @property tags The tag key-value pair information bound by the elastic guarantee service.
 */
public data class GetElasticityAssurancesPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val privatePoolOptionsIds: List<String>? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetElasticityAssurancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetElasticityAssurancesPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetElasticityAssurancesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .privatePoolOptionsIds(privatePoolOptionsIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetElasticityAssurancesPlainArgs].
 */
@PulumiTagMarker
public class GetElasticityAssurancesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var privatePoolOptionsIds: List<String>? = null

    private var resourceGroupId: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value A list of Elasticity Assurance IDs.
     */
    @JvmName("eblkxsunesavdmrh")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Elasticity Assurance IDs.
     */
    @JvmName("pkdpkymbnlijigkd")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("gggrnhdytqimxnfr")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the elastic protection service.
     */
    @JvmName("jwhnjgpfydyjcuhu")
    public suspend fun privatePoolOptionsIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.privatePoolOptionsIds = mapped
    }

    /**
     * @param values The ID of the elastic protection service.
     */
    @JvmName("kjpyaaxhmfeukdmm")
    public suspend fun privatePoolOptionsIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privatePoolOptionsIds = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("dhknvntmfdfnjktg")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The status of flexible guarantee services. Possible values: `All`, `Preparing`, `Prepared`, `Active`, `Released`.
     */
    @JvmName("mtvyueflgakvmtph")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The tag key-value pair information bound by the elastic guarantee service.
     */
    @JvmName("xfjtfmvtghvdyhnr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values The tag key-value pair information bound by the elastic guarantee service.
     */
    @JvmName("eyewwmkvptobmkoy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetElasticityAssurancesPlainArgs = GetElasticityAssurancesPlainArgs(
        ids = ids,
        outputFile = outputFile,
        privatePoolOptionsIds = privatePoolOptionsIds,
        resourceGroupId = resourceGroupId,
        status = status,
        tags = tags,
    )
}
