@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetImagesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getImages.
 * @property actionType The scenario in which the image will be used. Default value: `CreateEcs`. Valid values:
 * * `CreateEcs`: instance creation.
 * * `ChangeOS`: replacement of the system disk or operating system.
 * @property architecture The image architecture. Valid values: `i386` and `x86_64`.
 * @property dryRun Specifies whether the image is running on an ECS instance. Default value: `false`. Valid values:
 * @property imageFamily The name of the image family. You can set this parameter to query images of the specified image family. This parameter is empty by default.
 * @property imageId The ID of the image.
 * @property imageName The name of the image.
 * @property imageOwnerId The ID of the Alibaba Cloud account to which the image belongs. This parameter takes effect only when you query shared images or community images.
 * @property instanceType The instance type for which the image can be used.
 * @property isSupportCloudInit Specifies whether the image supports cloud-init.
 * @property isSupportIoOptimized Specifies whether the image can be used on I/O optimized instances.
 * @property mostRecent If more than one result are returned, select the most recent one.
 * @property nameRegex A regex string to filter resulting images by name.
 * @property osType The operating system type of the image. Valid values: `windows` and `linux`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * > **NOTE:** At least one of the `name_regex`, `most_recent` and `owners` must be set.
 * @property owners Filter results by a specific image owner. Valid items are `system`, `self`, `others`, `marketplace`.
 * @property resourceGroupId The ID of the resource group to which the custom image belongs.
 * @property snapshotId The ID of the snapshot used to create the custom image.
 * @property status The status of the image. The following values are available, Separate multiple parameter values by using commas (,). Default value: `Available`. Valid values:
 * * `Creating`: The image is being created.
 * * `Waiting`: The image is waiting to be processed.
 * * `Available`: The image is available.
 * * `UnAvailable`: The image is unavailable.
 * * `CreateFailed`: The image failed to be created.
 * * `Deprecated`: The image is discontinued.
 * @property tags A mapping of tags to assign to the resource.
 * @property usage Specifies whether to check the validity of the request without actually making the request. Valid values:
 */
public data class GetImagesPlainArgs(
    public val actionType: String? = null,
    public val architecture: String? = null,
    public val dryRun: Boolean? = null,
    public val imageFamily: String? = null,
    public val imageId: String? = null,
    public val imageName: String? = null,
    public val imageOwnerId: String? = null,
    public val instanceType: String? = null,
    public val isSupportCloudInit: Boolean? = null,
    public val isSupportIoOptimized: Boolean? = null,
    public val mostRecent: Boolean? = null,
    public val nameRegex: String? = null,
    public val osType: String? = null,
    public val outputFile: String? = null,
    public val owners: String? = null,
    public val resourceGroupId: String? = null,
    public val snapshotId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val usage: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetImagesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetImagesPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetImagesPlainArgs.builder()
            .actionType(actionType?.let({ args0 -> args0 }))
            .architecture(architecture?.let({ args0 -> args0 }))
            .dryRun(dryRun?.let({ args0 -> args0 }))
            .imageFamily(imageFamily?.let({ args0 -> args0 }))
            .imageId(imageId?.let({ args0 -> args0 }))
            .imageName(imageName?.let({ args0 -> args0 }))
            .imageOwnerId(imageOwnerId?.let({ args0 -> args0 }))
            .instanceType(instanceType?.let({ args0 -> args0 }))
            .isSupportCloudInit(isSupportCloudInit?.let({ args0 -> args0 }))
            .isSupportIoOptimized(isSupportIoOptimized?.let({ args0 -> args0 }))
            .mostRecent(mostRecent?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .osType(osType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .owners(owners?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .snapshotId(snapshotId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .usage(usage?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetImagesPlainArgs].
 */
@PulumiTagMarker
public class GetImagesPlainArgsBuilder internal constructor() {
    private var actionType: String? = null

    private var architecture: String? = null

    private var dryRun: Boolean? = null

    private var imageFamily: String? = null

    private var imageId: String? = null

    private var imageName: String? = null

    private var imageOwnerId: String? = null

    private var instanceType: String? = null

    private var isSupportCloudInit: Boolean? = null

    private var isSupportIoOptimized: Boolean? = null

    private var mostRecent: Boolean? = null

    private var nameRegex: String? = null

    private var osType: String? = null

    private var outputFile: String? = null

    private var owners: String? = null

    private var resourceGroupId: String? = null

    private var snapshotId: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var usage: String? = null

    /**
     * @param value The scenario in which the image will be used. Default value: `CreateEcs`. Valid values:
     * * `CreateEcs`: instance creation.
     * * `ChangeOS`: replacement of the system disk or operating system.
     */
    @JvmName("nmodsfbcvbyrehae")
    public suspend fun actionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.actionType = mapped
    }

    /**
     * @param value The image architecture. Valid values: `i386` and `x86_64`.
     */
    @JvmName("esqjnlqastmcltvs")
    public suspend fun architecture(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.architecture = mapped
    }

    /**
     * @param value Specifies whether the image is running on an ECS instance. Default value: `false`. Valid values:
     */
    @JvmName("pkvopqpdiksnhxge")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dryRun = mapped
    }

    /**
     * @param value The name of the image family. You can set this parameter to query images of the specified image family. This parameter is empty by default.
     */
    @JvmName("dgmnftmdxpatbsow")
    public suspend fun imageFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.imageFamily = mapped
    }

    /**
     * @param value The ID of the image.
     */
    @JvmName("teqyilimcxuulusb")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.imageId = mapped
    }

    /**
     * @param value The name of the image.
     */
    @JvmName("ybexlegeninndqps")
    public suspend fun imageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.imageName = mapped
    }

    /**
     * @param value The ID of the Alibaba Cloud account to which the image belongs. This parameter takes effect only when you query shared images or community images.
     */
    @JvmName("ftvesvvhodgpsvuk")
    public suspend fun imageOwnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.imageOwnerId = mapped
    }

    /**
     * @param value The instance type for which the image can be used.
     */
    @JvmName("nybsxmimgjfqfffm")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceType = mapped
    }

    /**
     * @param value Specifies whether the image supports cloud-init.
     */
    @JvmName("grurakluqbkdjjbl")
    public suspend fun isSupportCloudInit(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.isSupportCloudInit = mapped
    }

    /**
     * @param value Specifies whether the image can be used on I/O optimized instances.
     */
    @JvmName("ngrfqiqpssiggyvl")
    public suspend fun isSupportIoOptimized(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.isSupportIoOptimized = mapped
    }

    /**
     * @param value If more than one result are returned, select the most recent one.
     */
    @JvmName("kqewiwnfjdhybjre")
    public suspend fun mostRecent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.mostRecent = mapped
    }

    /**
     * @param value A regex string to filter resulting images by name.
     */
    @JvmName("rvkpoywymxecyjmo")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The operating system type of the image. Valid values: `windows` and `linux`.
     */
    @JvmName("nvhqqvlrmceagjpf")
    public suspend fun osType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.osType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     * > **NOTE:** At least one of the `name_regex`, `most_recent` and `owners` must be set.
     */
    @JvmName("qycvlyyidslsqdmn")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Filter results by a specific image owner. Valid items are `system`, `self`, `others`, `marketplace`.
     */
    @JvmName("edcgxhxhaogunxdb")
    public suspend fun owners(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.owners = mapped
    }

    /**
     * @param value The ID of the resource group to which the custom image belongs.
     */
    @JvmName("wwsfuqdkbtwqbcsx")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The ID of the snapshot used to create the custom image.
     */
    @JvmName("ekxbhjlxvlymndib")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.snapshotId = mapped
    }

    /**
     * @param value The status of the image. The following values are available, Separate multiple parameter values by using commas (,). Default value: `Available`. Valid values:
     * * `Creating`: The image is being created.
     * * `Waiting`: The image is waiting to be processed.
     * * `Available`: The image is available.
     * * `UnAvailable`: The image is unavailable.
     * * `CreateFailed`: The image failed to be created.
     * * `Deprecated`: The image is discontinued.
     */
    @JvmName("fokolrrxryifbded")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("lobkbumfvegqncjl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("oqwcbunhmvetgukn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Specifies whether to check the validity of the request without actually making the request. Valid values:
     */
    @JvmName("juqsdbwexngwtrff")
    public suspend fun usage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.usage = mapped
    }

    internal fun build(): GetImagesPlainArgs = GetImagesPlainArgs(
        actionType = actionType,
        architecture = architecture,
        dryRun = dryRun,
        imageFamily = imageFamily,
        imageId = imageId,
        imageName = imageName,
        imageOwnerId = imageOwnerId,
        instanceType = instanceType,
        isSupportCloudInit = isSupportCloudInit,
        isSupportIoOptimized = isSupportIoOptimized,
        mostRecent = mostRecent,
        nameRegex = nameRegex,
        osType = osType,
        outputFile = outputFile,
        owners = owners,
        resourceGroupId = resourceGroupId,
        snapshotId = snapshotId,
        status = status,
        tags = tags,
        usage = usage,
    )
}
