@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetInstanceKeywordsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceKeywords.
 * @property key The type of reserved keyword to query. Valid values: `account`, `database`.
 * @property outputFile File name where to save data source results (after running `pulumi up`).
 */
public data class GetInstanceKeywordsPlainArgs(
    public val key: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetInstanceKeywordsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetInstanceKeywordsPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetInstanceKeywordsPlainArgs.builder()
            .key(key.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceKeywordsPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceKeywordsPlainArgsBuilder internal constructor() {
    private var key: String? = null

    private var outputFile: String? = null

    /**
     * @param value The type of reserved keyword to query. Valid values: `account`, `database`.
     */
    @JvmName("vhjptrbrkoxspuba")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.key = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi up`).
     */
    @JvmName("twxwmkdybxbmkjhg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetInstanceKeywordsPlainArgs = GetInstanceKeywordsPlainArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        outputFile = outputFile,
    )
}
