@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetInstanceTypeFamiliesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceTypeFamilies.
 * @property generation The generation of the instance type family, Valid values: `ecs-1`, `ecs-2`, `ecs-3`, `ecs-4`, `ecs-5`, `ecs-6`. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.htm).
 * @property instanceChargeType Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property spotStrategy Filter the results by ECS spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
 * @property zoneId The Zone to launch the instance.
 */
public data class GetInstanceTypeFamiliesPlainArgs(
    public val generation: String? = null,
    public val instanceChargeType: String? = null,
    public val outputFile: String? = null,
    public val spotStrategy: String? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetInstanceTypeFamiliesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetInstanceTypeFamiliesPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetInstanceTypeFamiliesPlainArgs.builder()
            .generation(generation?.let({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .spotStrategy(spotStrategy?.let({ args0 -> args0 }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceTypeFamiliesPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceTypeFamiliesPlainArgsBuilder internal constructor() {
    private var generation: String? = null

    private var instanceChargeType: String? = null

    private var outputFile: String? = null

    private var spotStrategy: String? = null

    private var zoneId: String? = null

    /**
     * @param value The generation of the instance type family, Valid values: `ecs-1`, `ecs-2`, `ecs-3`, `ecs-4`, `ecs-5`, `ecs-6`. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.htm).
     */
    @JvmName("gtcvfihohbbgadas")
    public suspend fun generation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.generation = mapped
    }

    /**
     * @param value Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
     */
    @JvmName("woflwghdxvtpoupy")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceChargeType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dwwugfdhfcedevlh")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Filter the results by ECS spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
     */
    @JvmName("mwxhcpdiibtekrmb")
    public suspend fun spotStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.spotStrategy = mapped
    }

    /**
     * @param value The Zone to launch the instance.
     */
    @JvmName("qnkesvglyoojirdv")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetInstanceTypeFamiliesPlainArgs = GetInstanceTypeFamiliesPlainArgs(
        generation = generation,
        instanceChargeType = instanceChargeType,
        outputFile = outputFile,
        spotStrategy = spotStrategy,
        zoneId = zoneId,
    )
}
