@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceTypes.
 * @property availabilityZone The zone where instance types are supported.
 * @property cpuCoreCount Filter the results to a specific number of cpu cores.
 * @property eniAmount Filter the result whose network interface number is no more than `eni_amount`.
 * @property gpuAmount The GPU amount of an instance type.
 * @property gpuSpec The GPU spec of an instance type.
 * @property imageId The ID of the image.
 * @property instanceChargeType Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PostPaid`.
 * @property instanceType Instance specifications. For more information, see instance Specification Family, or you can call the describe instance types interface to get the latest specification table.
 * @property instanceTypeFamily Filter the results based on their family name. For example: 'ecs.n4'.
 * @property isOutdated If true, outdated instance types are included in the results. Default to false.
 * @property kubernetesNodeRole Filter the result which is used to create a kubernetes cluster
 * and managed kubernetes cluster. Optional Values: `Master` and `Worker`.
 * @property memorySize Filter the results to a specific memory size in GB.
 * @property minimumEniIpv6AddressQuantity The minimum number of IPv6 addresses per ENI. **Note:** If an instance type supports fewer IPv6 addresses per ENI than the specified value, information about the instance type is not queried.
 * @property minimumEniPrivateIpAddressQuantity The minimum expected IPv4 address upper limit of a single ENI when querying instance specifications. **Note:** If an instance type supports fewer IPv4 addresses per ENI than the specified value, information about the instance type is not queried.
 * @property networkType Filter the results by network type. Valid values: `Classic` and `Vpc`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property sortedBy Sort mode, valid values: `CPU`, `Memory`, `Price`.
 * @property spotStrategy Filter the results by ECS spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
 * @property systemDiskCategory Filter the results by system disk category. Valid values: `cloud`, `ephemeral_ssd`, `cloud_essd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd_entry`, `cloud_auto`.
 * **NOTE**: Its default value `cloud_efficiency` has been removed from the version v1.150.0.
 */
public data class GetInstanceTypesPlainArgs(
    public val availabilityZone: String? = null,
    public val cpuCoreCount: Int? = null,
    public val eniAmount: Int? = null,
    public val gpuAmount: Int? = null,
    public val gpuSpec: String? = null,
    public val imageId: String? = null,
    public val instanceChargeType: String? = null,
    public val instanceType: String? = null,
    public val instanceTypeFamily: String? = null,
    public val isOutdated: Boolean? = null,
    public val kubernetesNodeRole: String? = null,
    public val memorySize: Double? = null,
    public val minimumEniIpv6AddressQuantity: Int? = null,
    public val minimumEniPrivateIpAddressQuantity: Int? = null,
    public val networkType: String? = null,
    public val outputFile: String? = null,
    public val sortedBy: String? = null,
    public val spotStrategy: String? = null,
    public val systemDiskCategory: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetInstanceTypesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetInstanceTypesPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetInstanceTypesPlainArgs.builder()
            .availabilityZone(availabilityZone?.let({ args0 -> args0 }))
            .cpuCoreCount(cpuCoreCount?.let({ args0 -> args0 }))
            .eniAmount(eniAmount?.let({ args0 -> args0 }))
            .gpuAmount(gpuAmount?.let({ args0 -> args0 }))
            .gpuSpec(gpuSpec?.let({ args0 -> args0 }))
            .imageId(imageId?.let({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.let({ args0 -> args0 }))
            .instanceType(instanceType?.let({ args0 -> args0 }))
            .instanceTypeFamily(instanceTypeFamily?.let({ args0 -> args0 }))
            .isOutdated(isOutdated?.let({ args0 -> args0 }))
            .kubernetesNodeRole(kubernetesNodeRole?.let({ args0 -> args0 }))
            .memorySize(memorySize?.let({ args0 -> args0 }))
            .minimumEniIpv6AddressQuantity(minimumEniIpv6AddressQuantity?.let({ args0 -> args0 }))
            .minimumEniPrivateIpAddressQuantity(minimumEniPrivateIpAddressQuantity?.let({ args0 -> args0 }))
            .networkType(networkType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .sortedBy(sortedBy?.let({ args0 -> args0 }))
            .spotStrategy(spotStrategy?.let({ args0 -> args0 }))
            .systemDiskCategory(systemDiskCategory?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceTypesPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceTypesPlainArgsBuilder internal constructor() {
    private var availabilityZone: String? = null

    private var cpuCoreCount: Int? = null

    private var eniAmount: Int? = null

    private var gpuAmount: Int? = null

    private var gpuSpec: String? = null

    private var imageId: String? = null

    private var instanceChargeType: String? = null

    private var instanceType: String? = null

    private var instanceTypeFamily: String? = null

    private var isOutdated: Boolean? = null

    private var kubernetesNodeRole: String? = null

    private var memorySize: Double? = null

    private var minimumEniIpv6AddressQuantity: Int? = null

    private var minimumEniPrivateIpAddressQuantity: Int? = null

    private var networkType: String? = null

    private var outputFile: String? = null

    private var sortedBy: String? = null

    private var spotStrategy: String? = null

    private var systemDiskCategory: String? = null

    /**
     * @param value The zone where instance types are supported.
     */
    @JvmName("tcsjoumcahbgwwjt")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availabilityZone = mapped
    }

    /**
     * @param value Filter the results to a specific number of cpu cores.
     */
    @JvmName("anraimypjejtcfxg")
    public suspend fun cpuCoreCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cpuCoreCount = mapped
    }

    /**
     * @param value Filter the result whose network interface number is no more than `eni_amount`.
     */
    @JvmName("rgawylxkyaxcyolt")
    public suspend fun eniAmount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.eniAmount = mapped
    }

    /**
     * @param value The GPU amount of an instance type.
     */
    @JvmName("qexlstkvjcjnimxe")
    public suspend fun gpuAmount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.gpuAmount = mapped
    }

    /**
     * @param value The GPU spec of an instance type.
     */
    @JvmName("vlvmbogkykccelqs")
    public suspend fun gpuSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.gpuSpec = mapped
    }

    /**
     * @param value The ID of the image.
     */
    @JvmName("nhrnkpxbubpfjawk")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.imageId = mapped
    }

    /**
     * @param value Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PostPaid`.
     */
    @JvmName("nvmmcdftrbyrqsml")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceChargeType = mapped
    }

    /**
     * @param value Instance specifications. For more information, see instance Specification Family, or you can call the describe instance types interface to get the latest specification table.
     */
    @JvmName("afgomgqlsbawfpmy")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceType = mapped
    }

    /**
     * @param value Filter the results based on their family name. For example: 'ecs.n4'.
     */
    @JvmName("sfeoqdixefhcmegi")
    public suspend fun instanceTypeFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceTypeFamily = mapped
    }

    /**
     * @param value If true, outdated instance types are included in the results. Default to false.
     */
    @JvmName("omnfarsabwcfdsjv")
    public suspend fun isOutdated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.isOutdated = mapped
    }

    /**
     * @param value Filter the result which is used to create a kubernetes cluster
     * and managed kubernetes cluster. Optional Values: `Master` and `Worker`.
     */
    @JvmName("njxsvrdbrlhuajjl")
    public suspend fun kubernetesNodeRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.kubernetesNodeRole = mapped
    }

    /**
     * @param value Filter the results to a specific memory size in GB.
     */
    @JvmName("qrpkuepifvhtewki")
    public suspend fun memorySize(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.memorySize = mapped
    }

    /**
     * @param value The minimum number of IPv6 addresses per ENI. **Note:** If an instance type supports fewer IPv6 addresses per ENI than the specified value, information about the instance type is not queried.
     */
    @JvmName("cevnexkhqcaeytvp")
    public suspend fun minimumEniIpv6AddressQuantity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.minimumEniIpv6AddressQuantity = mapped
    }

    /**
     * @param value The minimum expected IPv4 address upper limit of a single ENI when querying instance specifications. **Note:** If an instance type supports fewer IPv4 addresses per ENI than the specified value, information about the instance type is not queried.
     */
    @JvmName("onwmmvcklohufsns")
    public suspend fun minimumEniPrivateIpAddressQuantity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.minimumEniPrivateIpAddressQuantity = mapped
    }

    /**
     * @param value Filter the results by network type. Valid values: `Classic` and `Vpc`.
     */
    @JvmName("kmsktocsdcenopnq")
    public suspend fun networkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.networkType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("kirgqvbqvkhboaaa")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Sort mode, valid values: `CPU`, `Memory`, `Price`.
     */
    @JvmName("xvlpdvujlkjjiwgx")
    public suspend fun sortedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortedBy = mapped
    }

    /**
     * @param value Filter the results by ECS spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
     */
    @JvmName("shbsjwkbkofcajub")
    public suspend fun spotStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.spotStrategy = mapped
    }

    /**
     * @param value Filter the results by system disk category. Valid values: `cloud`, `ephemeral_ssd`, `cloud_essd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd_entry`, `cloud_auto`.
     * **NOTE**: Its default value `cloud_efficiency` has been removed from the version v1.150.0.
     */
    @JvmName("ojmsopttxcuvhgpw")
    public suspend fun systemDiskCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.systemDiskCategory = mapped
    }

    internal fun build(): GetInstanceTypesPlainArgs = GetInstanceTypesPlainArgs(
        availabilityZone = availabilityZone,
        cpuCoreCount = cpuCoreCount,
        eniAmount = eniAmount,
        gpuAmount = gpuAmount,
        gpuSpec = gpuSpec,
        imageId = imageId,
        instanceChargeType = instanceChargeType,
        instanceType = instanceType,
        instanceTypeFamily = instanceTypeFamily,
        isOutdated = isOutdated,
        kubernetesNodeRole = kubernetesNodeRole,
        memorySize = memorySize,
        minimumEniIpv6AddressQuantity = minimumEniIpv6AddressQuantity,
        minimumEniPrivateIpAddressQuantity = minimumEniPrivateIpAddressQuantity,
        networkType = networkType,
        outputFile = outputFile,
        sortedBy = sortedBy,
        spotStrategy = spotStrategy,
        systemDiskCategory = systemDiskCategory,
    )
}
