@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetNetworkInterfacesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNetworkInterfaces.
 * @property ids
 * @property instanceId ID of the instance that the ENI is attached to.
 * @property name Name of the ENI.
 * @property nameRegex
 * @property networkInterfaceName
 * @property outputFile
 * @property primaryIpAddress
 * @property privateIp Primary private IP of the ENI.
 * @property resourceGroupId The Id of resource group.
 * @property securityGroupId
 * @property serviceManaged
 * @property status Current status of the ENI.
 * @property tags A map of tags assigned to the ENI.
 * @property type
 * @property vpcId ID of the VPC that the ENI belongs to.
 * @property vswitchId ID of the vSwitch that the ENI is linked to.
 */
public data class GetNetworkInterfacesPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name'
      instead
  """,
    )
    public val name: String? = null,
    public val nameRegex: String? = null,
    public val networkInterfaceName: String? = null,
    public val outputFile: String? = null,
    public val primaryIpAddress: String? = null,
    @Deprecated(
        message = """
  Field 'private_ip' has been deprecated from provider version 1.123.1. New field
      'primary_ip_address' instead
  """,
    )
    public val privateIp: String? = null,
    public val resourceGroupId: String? = null,
    public val securityGroupId: String? = null,
    public val serviceManaged: Boolean? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String? = null,
    public val vpcId: String? = null,
    public val vswitchId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetNetworkInterfacesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetNetworkInterfacesPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetNetworkInterfacesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .networkInterfaceName(networkInterfaceName?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .primaryIpAddress(primaryIpAddress?.let({ args0 -> args0 }))
            .privateIp(privateIp?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.let({ args0 -> args0 }))
            .serviceManaged(serviceManaged?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.let({ args0 -> args0 }))
            .vpcId(vpcId?.let({ args0 -> args0 }))
            .vswitchId(vswitchId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkInterfacesPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkInterfacesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var name: String? = null

    private var nameRegex: String? = null

    private var networkInterfaceName: String? = null

    private var outputFile: String? = null

    private var primaryIpAddress: String? = null

    private var privateIp: String? = null

    private var resourceGroupId: String? = null

    private var securityGroupId: String? = null

    private var serviceManaged: Boolean? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var type: String? = null

    private var vpcId: String? = null

    private var vswitchId: String? = null

    /**
     * @param value
     */
    @JvmName("ognfsmnqocdpmpre")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values
     */
    @JvmName("rhbjvbqkmtuxrvwa")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value ID of the instance that the ENI is attached to.
     */
    @JvmName("ejehyggwxwrjekni")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value Name of the ENI.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name'
      instead
  """,
    )
    @JvmName("ytbsbrkusnxkqysy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("cebodvsdngflyyqq")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value
     */
    @JvmName("datgfehwdiublniq")
    public suspend fun networkInterfaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.networkInterfaceName = mapped
    }

    /**
     * @param value
     */
    @JvmName("upredmimpirpcjsu")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("mqoqexecxxcvgpcf")
    public suspend fun primaryIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.primaryIpAddress = mapped
    }

    /**
     * @param value Primary private IP of the ENI.
     */
    @Deprecated(
        message = """
  Field 'private_ip' has been deprecated from provider version 1.123.1. New field
      'primary_ip_address' instead
  """,
    )
    @JvmName("eikykbwvwmjgsrfl")
    public suspend fun privateIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.privateIp = mapped
    }

    /**
     * @param value The Id of resource group.
     */
    @JvmName("yvvmkhyhqystdxdv")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("guiuuntbxvmnlocd")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.securityGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("popxjgoaipvxwyhf")
    public suspend fun serviceManaged(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serviceManaged = mapped
    }

    /**
     * @param value Current status of the ENI.
     */
    @JvmName("rkjawoyfhvpsxpgj")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A map of tags assigned to the ENI.
     */
    @JvmName("kobjugvdlenloiwp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the ENI.
     */
    @JvmName("wybanqbwdvhlqpgr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("audvbgwmoyjlnvvw")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value ID of the VPC that the ENI belongs to.
     */
    @JvmName("bsqngeckrrjegrfh")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    /**
     * @param value ID of the vSwitch that the ENI is linked to.
     */
    @JvmName("bkmgmudntcwgjjrx")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vswitchId = mapped
    }

    internal fun build(): GetNetworkInterfacesPlainArgs = GetNetworkInterfacesPlainArgs(
        ids = ids,
        instanceId = instanceId,
        name = name,
        nameRegex = nameRegex,
        networkInterfaceName = networkInterfaceName,
        outputFile = outputFile,
        primaryIpAddress = primaryIpAddress,
        privateIp = privateIp,
        resourceGroupId = resourceGroupId,
        securityGroupId = securityGroupId,
        serviceManaged = serviceManaged,
        status = status,
        tags = tags,
        type = type,
        vpcId = vpcId,
        vswitchId = vswitchId,
    )
}
