@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetSecurityGroupRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSecurityGroupRules.
 * @property direction Authorization direction. Valid values are: `ingress` or `egress`.
 * @property groupId The ID of the security group that owns the rules.
 * @property ipProtocol The IP protocol. Valid values are: `tcp`, `udp`, `icmp`, `gre` and `all`.
 * @property nicType Refers to the network type. Can be either `internet` or `intranet`. The default value is `internet`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property policy Authorization policy. Can be either `accept` or `drop`. The default value is `accept`.
 */
public data class GetSecurityGroupRulesPlainArgs(
    public val direction: String? = null,
    public val groupId: String,
    public val ipProtocol: String? = null,
    public val nicType: String? = null,
    public val outputFile: String? = null,
    public val policy: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetSecurityGroupRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetSecurityGroupRulesPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetSecurityGroupRulesPlainArgs.builder()
            .direction(direction?.let({ args0 -> args0 }))
            .groupId(groupId.let({ args0 -> args0 }))
            .ipProtocol(ipProtocol?.let({ args0 -> args0 }))
            .nicType(nicType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .policy(policy?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecurityGroupRulesPlainArgs].
 */
@PulumiTagMarker
public class GetSecurityGroupRulesPlainArgsBuilder internal constructor() {
    private var direction: String? = null

    private var groupId: String? = null

    private var ipProtocol: String? = null

    private var nicType: String? = null

    private var outputFile: String? = null

    private var policy: String? = null

    /**
     * @param value Authorization direction. Valid values are: `ingress` or `egress`.
     */
    @JvmName("llnuuhaaycewbiyy")
    public suspend fun direction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.direction = mapped
    }

    /**
     * @param value The ID of the security group that owns the rules.
     */
    @JvmName("yispasrxkvyxdvfh")
    public suspend fun groupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupId = mapped
    }

    /**
     * @param value The IP protocol. Valid values are: `tcp`, `udp`, `icmp`, `gre` and `all`.
     */
    @JvmName("mcocsyxrrggamveo")
    public suspend fun ipProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ipProtocol = mapped
    }

    /**
     * @param value Refers to the network type. Can be either `internet` or `intranet`. The default value is `internet`.
     */
    @JvmName("pvjdgvwtyftvqgdj")
    public suspend fun nicType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nicType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("kmnkdsnnvrbknhpj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Authorization policy. Can be either `accept` or `drop`. The default value is `accept`.
     */
    @JvmName("cfuebukdrabxnmxj")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.policy = mapped
    }

    internal fun build(): GetSecurityGroupRulesPlainArgs = GetSecurityGroupRulesPlainArgs(
        direction = direction,
        groupId = groupId ?: throw PulumiNullFieldException("groupId"),
        ipProtocol = ipProtocol,
        nicType = nicType,
        outputFile = outputFile,
        policy = policy,
    )
}
