@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.GetSnapshotsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSnapshots.
 * @property category
 * @property dryRun
 * @property encrypted Whether the snapshot is encrypted or not.
 * @property ids A list of snapshot IDs.
 * @property kmsKeyId
 * @property nameRegex
 * @property outputFile
 * @property resourceGroupId
 * @property snapshotLinkId
 * @property snapshotName
 * @property snapshotType
 * @property sourceDiskType Source disk attribute. Value range: `System`,`Data`.
 * @property status The snapshot status. Value range: `progressing`, `accomplished` and `failed`.
 * @property tags A map of tags assigned to the snapshot.
 * @property type
 * @property usage Whether the snapshots are used to create resources or not. Value range: `image`, `disk`, `image_disk` and `none`.
 */
public data class GetSnapshotsPlainArgs(
    public val category: String? = null,
    public val dryRun: Boolean? = null,
    public val encrypted: Boolean? = null,
    public val ids: List<String>? = null,
    public val kmsKeyId: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val snapshotLinkId: String? = null,
    public val snapshotName: String? = null,
    public val snapshotType: String? = null,
    public val sourceDiskType: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String? = null,
    public val usage: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.GetSnapshotsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.GetSnapshotsPlainArgs =
        com.pulumi.alicloud.ecs.inputs.GetSnapshotsPlainArgs.builder()
            .category(category?.let({ args0 -> args0 }))
            .dryRun(dryRun?.let({ args0 -> args0 }))
            .encrypted(encrypted?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .kmsKeyId(kmsKeyId?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .snapshotLinkId(snapshotLinkId?.let({ args0 -> args0 }))
            .snapshotName(snapshotName?.let({ args0 -> args0 }))
            .snapshotType(snapshotType?.let({ args0 -> args0 }))
            .sourceDiskType(sourceDiskType?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.let({ args0 -> args0 }))
            .usage(usage?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSnapshotsPlainArgs].
 */
@PulumiTagMarker
public class GetSnapshotsPlainArgsBuilder internal constructor() {
    private var category: String? = null

    private var dryRun: Boolean? = null

    private var encrypted: Boolean? = null

    private var ids: List<String>? = null

    private var kmsKeyId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var snapshotLinkId: String? = null

    private var snapshotName: String? = null

    private var snapshotType: String? = null

    private var sourceDiskType: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var type: String? = null

    private var usage: String? = null

    /**
     * @param value
     */
    @JvmName("hokmevujmsjfoeev")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.category = mapped
    }

    /**
     * @param value
     */
    @JvmName("fgpjbykmdwplbivp")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dryRun = mapped
    }

    /**
     * @param value Whether the snapshot is encrypted or not.
     */
    @JvmName("ebgfqbebgyaypeqq")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.encrypted = mapped
    }

    /**
     * @param value A list of snapshot IDs.
     */
    @JvmName("liilyjcsgwagnygp")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of snapshot IDs.
     */
    @JvmName("aqmqgttldatfidqn")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("akutquxbhqokqmrb")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.kmsKeyId = mapped
    }

    /**
     * @param value
     */
    @JvmName("krhiirqmrroiilab")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value
     */
    @JvmName("qlpqabkphbvcsvnu")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("qullcyttwxjltdgu")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("aixxfacymkddgswq")
    public suspend fun snapshotLinkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.snapshotLinkId = mapped
    }

    /**
     * @param value
     */
    @JvmName("xqvworjkxuqobybt")
    public suspend fun snapshotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.snapshotName = mapped
    }

    /**
     * @param value
     */
    @JvmName("ihsoxkxaadkkmohj")
    public suspend fun snapshotType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.snapshotType = mapped
    }

    /**
     * @param value Source disk attribute. Value range: `System`,`Data`.
     */
    @JvmName("onuebnsbnhpmfajl")
    public suspend fun sourceDiskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sourceDiskType = mapped
    }

    /**
     * @param value The snapshot status. Value range: `progressing`, `accomplished` and `failed`.
     */
    @JvmName("hycyqivxkenqxkpy")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A map of tags assigned to the snapshot.
     */
    @JvmName("hcslemkqwrfkdftf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the snapshot.
     */
    @JvmName("bfslxecchfvxumko")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("eletisqanvbhojll")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value Whether the snapshots are used to create resources or not. Value range: `image`, `disk`, `image_disk` and `none`.
     */
    @JvmName("ddxapvwbmkfdlgvp")
    public suspend fun usage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.usage = mapped
    }

    internal fun build(): GetSnapshotsPlainArgs = GetSnapshotsPlainArgs(
        category = category,
        dryRun = dryRun,
        encrypted = encrypted,
        ids = ids,
        kmsKeyId = kmsKeyId,
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        snapshotLinkId = snapshotLinkId,
        snapshotName = snapshotName,
        snapshotType = snapshotType,
        sourceDiskType = sourceDiskType,
        status = status,
        tags = tags,
        type = type,
        usage = usage,
    )
}
