@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.ImageDiskDeviceMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property device The device name of disk N in the custom image. Valid values:
 * - For disks other than basic disks, such as standard SSDs, ultra disks, and enhanced SSDs (ESSDs), the valid values range from /dev/vda to /dev/vdz in alphabetical order.
 * - For basic disks, the valid values range from /dev/xvda to /dev/xvdz in alphabetical order.
 * @property diskType The type of disk N in the custom image. You can specify this parameter to create the system disk of the custom image from a data disk snapshot. If you do not specify this parameter, the disk type is determined by the corresponding snapshot. Valid values:
 * - system: system disk. You can specify only one snapshot to use to create the system disk in the custom image.
 * - data: data disk. You can specify up to 16 snapshots to use to create data disks in the custom image.
 * @property format Image format.
 * @property importOssBucket Import the bucket of the OSS to which the image belongs.
 * @property importOssObject Import the object of the OSS to which the image file belongs.
 * @property progress Copy the progress of the task.
 * @property remainTime For an image being replicated, return the remaining time of the replication task, in seconds.
 * @property size The size of disk N in the custom image. Unit: GiB. The valid values and default value of DiskDeviceMapping.N.Size vary based on the value of DiskDeviceMapping.N.SnapshotId.
 * - If no corresponding snapshot IDs are specified in the value of DiskDeviceMapping.N.SnapshotId, DiskDeviceMapping.N.Size has the following valid values and default values:
 * *   For basic disks, the valid values range from 5 to 2000, and the default value is 5.
 * *   For other disks, the valid values range from 20 to 32768, and the default value is 20.
 * - If a corresponding snapshot ID is specified in the value of DiskDeviceMapping.N.SnapshotId, the value of DiskDeviceMapping.N.Size must be greater than or equal to the size of the specified snapshot. The default value of DiskDeviceMapping.N.Size is the size of the specified snapshot.
 * @property snapshotId The ID of snapshot N to use to create the custom image. .
 */
public data class ImageDiskDeviceMappingArgs(
    public val device: Output<String>? = null,
    public val diskType: Output<String>? = null,
    public val format: Output<String>? = null,
    public val importOssBucket: Output<String>? = null,
    public val importOssObject: Output<String>? = null,
    public val progress: Output<String>? = null,
    public val remainTime: Output<Int>? = null,
    public val size: Output<Int>? = null,
    public val snapshotId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.ImageDiskDeviceMappingArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.ImageDiskDeviceMappingArgs =
        com.pulumi.alicloud.ecs.inputs.ImageDiskDeviceMappingArgs.builder()
            .device(device?.applyValue({ args0 -> args0 }))
            .diskType(diskType?.applyValue({ args0 -> args0 }))
            .format(format?.applyValue({ args0 -> args0 }))
            .importOssBucket(importOssBucket?.applyValue({ args0 -> args0 }))
            .importOssObject(importOssObject?.applyValue({ args0 -> args0 }))
            .progress(progress?.applyValue({ args0 -> args0 }))
            .remainTime(remainTime?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageDiskDeviceMappingArgs].
 */
@PulumiTagMarker
public class ImageDiskDeviceMappingArgsBuilder internal constructor() {
    private var device: Output<String>? = null

    private var diskType: Output<String>? = null

    private var format: Output<String>? = null

    private var importOssBucket: Output<String>? = null

    private var importOssObject: Output<String>? = null

    private var progress: Output<String>? = null

    private var remainTime: Output<Int>? = null

    private var size: Output<Int>? = null

    private var snapshotId: Output<String>? = null

    /**
     * @param value The device name of disk N in the custom image. Valid values:
     * - For disks other than basic disks, such as standard SSDs, ultra disks, and enhanced SSDs (ESSDs), the valid values range from /dev/vda to /dev/vdz in alphabetical order.
     * - For basic disks, the valid values range from /dev/xvda to /dev/xvdz in alphabetical order.
     */
    @JvmName("lwqdjmujiwrckbpx")
    public suspend fun device(`value`: Output<String>) {
        this.device = value
    }

    /**
     * @param value The type of disk N in the custom image. You can specify this parameter to create the system disk of the custom image from a data disk snapshot. If you do not specify this parameter, the disk type is determined by the corresponding snapshot. Valid values:
     * - system: system disk. You can specify only one snapshot to use to create the system disk in the custom image.
     * - data: data disk. You can specify up to 16 snapshots to use to create data disks in the custom image.
     */
    @JvmName("qbaovnmabsvwhmir")
    public suspend fun diskType(`value`: Output<String>) {
        this.diskType = value
    }

    /**
     * @param value Image format.
     */
    @JvmName("dntngkmpxelmhykw")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value Import the bucket of the OSS to which the image belongs.
     */
    @JvmName("jutvxfgtfiawygtw")
    public suspend fun importOssBucket(`value`: Output<String>) {
        this.importOssBucket = value
    }

    /**
     * @param value Import the object of the OSS to which the image file belongs.
     */
    @JvmName("curtycunfsfihqbx")
    public suspend fun importOssObject(`value`: Output<String>) {
        this.importOssObject = value
    }

    /**
     * @param value Copy the progress of the task.
     */
    @JvmName("lrfgskbarflrahre")
    public suspend fun progress(`value`: Output<String>) {
        this.progress = value
    }

    /**
     * @param value For an image being replicated, return the remaining time of the replication task, in seconds.
     */
    @JvmName("hgkmurcujujokrni")
    public suspend fun remainTime(`value`: Output<Int>) {
        this.remainTime = value
    }

    /**
     * @param value The size of disk N in the custom image. Unit: GiB. The valid values and default value of DiskDeviceMapping.N.Size vary based on the value of DiskDeviceMapping.N.SnapshotId.
     * - If no corresponding snapshot IDs are specified in the value of DiskDeviceMapping.N.SnapshotId, DiskDeviceMapping.N.Size has the following valid values and default values:
     * *   For basic disks, the valid values range from 5 to 2000, and the default value is 5.
     * *   For other disks, the valid values range from 20 to 32768, and the default value is 20.
     * - If a corresponding snapshot ID is specified in the value of DiskDeviceMapping.N.SnapshotId, the value of DiskDeviceMapping.N.Size must be greater than or equal to the size of the specified snapshot. The default value of DiskDeviceMapping.N.Size is the size of the specified snapshot.
     */
    @JvmName("lbhggyobydbillxr")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The ID of snapshot N to use to create the custom image. .
     */
    @JvmName("cqfgqhjscsmcmujc")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value The device name of disk N in the custom image. Valid values:
     * - For disks other than basic disks, such as standard SSDs, ultra disks, and enhanced SSDs (ESSDs), the valid values range from /dev/vda to /dev/vdz in alphabetical order.
     * - For basic disks, the valid values range from /dev/xvda to /dev/xvdz in alphabetical order.
     */
    @JvmName("rofbgtkhchnjtjgw")
    public suspend fun device(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.device = mapped
    }

    /**
     * @param value The type of disk N in the custom image. You can specify this parameter to create the system disk of the custom image from a data disk snapshot. If you do not specify this parameter, the disk type is determined by the corresponding snapshot. Valid values:
     * - system: system disk. You can specify only one snapshot to use to create the system disk in the custom image.
     * - data: data disk. You can specify up to 16 snapshots to use to create data disks in the custom image.
     */
    @JvmName("unhfippaywbxmhga")
    public suspend fun diskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value Image format.
     */
    @JvmName("iolsvadtstditknl")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Import the bucket of the OSS to which the image belongs.
     */
    @JvmName("aenhbptgbyipvide")
    public suspend fun importOssBucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importOssBucket = mapped
    }

    /**
     * @param value Import the object of the OSS to which the image file belongs.
     */
    @JvmName("owgviljcapjutbce")
    public suspend fun importOssObject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importOssObject = mapped
    }

    /**
     * @param value Copy the progress of the task.
     */
    @JvmName("stqqulhhfkjtcpsd")
    public suspend fun progress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.progress = mapped
    }

    /**
     * @param value For an image being replicated, return the remaining time of the replication task, in seconds.
     */
    @JvmName("haghtcqbgwwfadab")
    public suspend fun remainTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remainTime = mapped
    }

    /**
     * @param value The size of disk N in the custom image. Unit: GiB. The valid values and default value of DiskDeviceMapping.N.Size vary based on the value of DiskDeviceMapping.N.SnapshotId.
     * - If no corresponding snapshot IDs are specified in the value of DiskDeviceMapping.N.SnapshotId, DiskDeviceMapping.N.Size has the following valid values and default values:
     * *   For basic disks, the valid values range from 5 to 2000, and the default value is 5.
     * *   For other disks, the valid values range from 20 to 32768, and the default value is 20.
     * - If a corresponding snapshot ID is specified in the value of DiskDeviceMapping.N.SnapshotId, the value of DiskDeviceMapping.N.Size must be greater than or equal to the size of the specified snapshot. The default value of DiskDeviceMapping.N.Size is the size of the specified snapshot.
     */
    @JvmName("iokxqbupjfbwmryp")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The ID of snapshot N to use to create the custom image. .
     */
    @JvmName("xqqiyxsetoavwnbe")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    internal fun build(): ImageDiskDeviceMappingArgs = ImageDiskDeviceMappingArgs(
        device = device,
        diskType = diskType,
        format = format,
        importOssBucket = importOssBucket,
        importOssObject = importOssObject,
        progress = progress,
        remainTime = remainTime,
        size = size,
        snapshotId = snapshotId,
    )
}
