@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.ImageFeaturesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property nvmeSupport Specifies whether to support the Non-Volatile Memory Express (NVMe) protocol. Valid values:
 * - supported: The image supports NVMe. Instances created from this image also support NVMe.
 * - unsupported: The image does not support NVMe. Instances created from this image do not support NVMe.
 */
public data class ImageFeaturesArgs(
    public val nvmeSupport: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.ImageFeaturesArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.ImageFeaturesArgs =
        com.pulumi.alicloud.ecs.inputs.ImageFeaturesArgs.builder()
            .nvmeSupport(nvmeSupport?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageFeaturesArgs].
 */
@PulumiTagMarker
public class ImageFeaturesArgsBuilder internal constructor() {
    private var nvmeSupport: Output<String>? = null

    /**
     * @param value Specifies whether to support the Non-Volatile Memory Express (NVMe) protocol. Valid values:
     * - supported: The image supports NVMe. Instances created from this image also support NVMe.
     * - unsupported: The image does not support NVMe. Instances created from this image do not support NVMe.
     */
    @JvmName("vefyjrgsbliisclw")
    public suspend fun nvmeSupport(`value`: Output<String>) {
        this.nvmeSupport = value
    }

    /**
     * @param value Specifies whether to support the Non-Volatile Memory Express (NVMe) protocol. Valid values:
     * - supported: The image supports NVMe. Instances created from this image also support NVMe.
     * - unsupported: The image does not support NVMe. Instances created from this image do not support NVMe.
     */
    @JvmName("iojgmknxthdhjpfq")
    public suspend fun nvmeSupport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nvmeSupport = mapped
    }

    internal fun build(): ImageFeaturesArgs = ImageFeaturesArgs(
        nvmeSupport = nvmeSupport,
    )
}
