@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.ImageImportDiskDeviceMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property device The device name of the disk.
 * @property diskImageSize The size of the disk. Default value: `5`.
 * @property format The format of the image. Valid values: `RAW`, `VHD`, `qcow2`.
 * @property ossBucket The OSS bucket where the image file is stored.
 * @property ossObject The name (key) of the object that the uploaded image is stored as in the OSS bucket.
 */
public data class ImageImportDiskDeviceMappingArgs(
    public val device: Output<String>? = null,
    public val diskImageSize: Output<Int>? = null,
    public val format: Output<String>? = null,
    public val ossBucket: Output<String>? = null,
    public val ossObject: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.ImageImportDiskDeviceMappingArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.ImageImportDiskDeviceMappingArgs =
        com.pulumi.alicloud.ecs.inputs.ImageImportDiskDeviceMappingArgs.builder()
            .device(device?.applyValue({ args0 -> args0 }))
            .diskImageSize(diskImageSize?.applyValue({ args0 -> args0 }))
            .format(format?.applyValue({ args0 -> args0 }))
            .ossBucket(ossBucket?.applyValue({ args0 -> args0 }))
            .ossObject(ossObject?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageImportDiskDeviceMappingArgs].
 */
@PulumiTagMarker
public class ImageImportDiskDeviceMappingArgsBuilder internal constructor() {
    private var device: Output<String>? = null

    private var diskImageSize: Output<Int>? = null

    private var format: Output<String>? = null

    private var ossBucket: Output<String>? = null

    private var ossObject: Output<String>? = null

    /**
     * @param value The device name of the disk.
     */
    @JvmName("cudfbssnhgfojufs")
    public suspend fun device(`value`: Output<String>) {
        this.device = value
    }

    /**
     * @param value The size of the disk. Default value: `5`.
     */
    @JvmName("qaacbcsqrkhrmcur")
    public suspend fun diskImageSize(`value`: Output<Int>) {
        this.diskImageSize = value
    }

    /**
     * @param value The format of the image. Valid values: `RAW`, `VHD`, `qcow2`.
     */
    @JvmName("xdwgwlmsaicjnvfx")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value The OSS bucket where the image file is stored.
     */
    @JvmName("vgkcvblielalmyxl")
    public suspend fun ossBucket(`value`: Output<String>) {
        this.ossBucket = value
    }

    /**
     * @param value The name (key) of the object that the uploaded image is stored as in the OSS bucket.
     */
    @JvmName("ahavdegwnloxdpqr")
    public suspend fun ossObject(`value`: Output<String>) {
        this.ossObject = value
    }

    /**
     * @param value The device name of the disk.
     */
    @JvmName("vvtxsnhjbfhhbhbh")
    public suspend fun device(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.device = mapped
    }

    /**
     * @param value The size of the disk. Default value: `5`.
     */
    @JvmName("gyndcgxooigblcbi")
    public suspend fun diskImageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskImageSize = mapped
    }

    /**
     * @param value The format of the image. Valid values: `RAW`, `VHD`, `qcow2`.
     */
    @JvmName("tbyoqoqaohwfwxes")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The OSS bucket where the image file is stored.
     */
    @JvmName("qpslxhkdflnqffst")
    public suspend fun ossBucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossBucket = mapped
    }

    /**
     * @param value The name (key) of the object that the uploaded image is stored as in the OSS bucket.
     */
    @JvmName("mkutagqkipcgxwgm")
    public suspend fun ossObject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossObject = mapped
    }

    internal fun build(): ImageImportDiskDeviceMappingArgs = ImageImportDiskDeviceMappingArgs(
        device = device,
        diskImageSize = diskImageSize,
        format = format,
        ossBucket = ossBucket,
        ossObject = ossObject,
    )
}
