@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.InstanceDataDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoSnapshotPolicyId The ID of the automatic snapshot policy applied to the system disk.
 * @property category The category of the disk:
 * @property deleteWithInstance Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_essd, cloud_ssd disk. If the category of this data disk was ephemeral_ssd, please don't set this param. Default value: `true`.
 * @property description The description of the data disk.
 * @property device The mount point of the data disk.
 * @property encrypted Encrypted the data in this disk. Default value: `false`.
 * @property kmsKeyId The KMS key ID corresponding to the Nth data disk.
 * @property name The name of the data disk.
 * @property performanceLevel The performance level of the ESSD used as data disk:
 * - `PL0`: A single ESSD can deliver up to 10,000 random read/write IOPS.
 * - `PL1`: A single ESSD can deliver up to 50,000 random read/write IOPS.
 * - `PL2`: A single ESSD can deliver up to 100,000 random read/write IOPS.
 * - `PL3`: A single ESSD can deliver up to 1,000,000 random read/write IOPS.
 * Default to `PL1`.
 * @property size The size of the data disk.
 * - cloud：[5, 2000]
 * - cloud_efficiency：[20, 32768]
 * - cloud_ssd：[20, 32768]
 * - cloud_essd：[20, 32768]
 * - ephemeral_ssd: [5, 800]
 * @property snapshotId The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
 */
public data class InstanceDataDiskArgs(
    public val autoSnapshotPolicyId: Output<String>? = null,
    public val category: Output<String>? = null,
    public val deleteWithInstance: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val device: Output<String>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val performanceLevel: Output<String>? = null,
    public val size: Output<Int>,
    public val snapshotId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.InstanceDataDiskArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.InstanceDataDiskArgs =
        com.pulumi.alicloud.ecs.inputs.InstanceDataDiskArgs.builder()
            .autoSnapshotPolicyId(autoSnapshotPolicyId?.applyValue({ args0 -> args0 }))
            .category(category?.applyValue({ args0 -> args0 }))
            .deleteWithInstance(deleteWithInstance?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .device(device?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .performanceLevel(performanceLevel?.applyValue({ args0 -> args0 }))
            .size(size.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceDataDiskArgs].
 */
@PulumiTagMarker
public class InstanceDataDiskArgsBuilder internal constructor() {
    private var autoSnapshotPolicyId: Output<String>? = null

    private var category: Output<String>? = null

    private var deleteWithInstance: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var device: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var performanceLevel: Output<String>? = null

    private var size: Output<Int>? = null

    private var snapshotId: Output<String>? = null

    /**
     * @param value The ID of the automatic snapshot policy applied to the system disk.
     */
    @JvmName("pjocnrlvrkwcfndu")
    public suspend fun autoSnapshotPolicyId(`value`: Output<String>) {
        this.autoSnapshotPolicyId = value
    }

    /**
     * @param value The category of the disk:
     */
    @JvmName("jelrkjechyuomhhq")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_essd, cloud_ssd disk. If the category of this data disk was ephemeral_ssd, please don't set this param. Default value: `true`.
     */
    @JvmName("pnyvsycgfilcmtmt")
    public suspend fun deleteWithInstance(`value`: Output<Boolean>) {
        this.deleteWithInstance = value
    }

    /**
     * @param value The description of the data disk.
     */
    @JvmName("qhkjkoychaagohuq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The mount point of the data disk.
     */
    @JvmName("vprgrmpfprobfrpd")
    public suspend fun device(`value`: Output<String>) {
        this.device = value
    }

    /**
     * @param value Encrypted the data in this disk. Default value: `false`.
     */
    @JvmName("amhkcfgsupyrgvpo")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value The KMS key ID corresponding to the Nth data disk.
     */
    @JvmName("xhpnxeltpiwxxdas")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The name of the data disk.
     */
    @JvmName("btgortmxsoqyvral")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The performance level of the ESSD used as data disk:
     * - `PL0`: A single ESSD can deliver up to 10,000 random read/write IOPS.
     * - `PL1`: A single ESSD can deliver up to 50,000 random read/write IOPS.
     * - `PL2`: A single ESSD can deliver up to 100,000 random read/write IOPS.
     * - `PL3`: A single ESSD can deliver up to 1,000,000 random read/write IOPS.
     * Default to `PL1`.
     */
    @JvmName("ugbmspncntendlwo")
    public suspend fun performanceLevel(`value`: Output<String>) {
        this.performanceLevel = value
    }

    /**
     * @param value The size of the data disk.
     * - cloud：[5, 2000]
     * - cloud_efficiency：[20, 32768]
     * - cloud_ssd：[20, 32768]
     * - cloud_essd：[20, 32768]
     * - ephemeral_ssd: [5, 800]
     */
    @JvmName("wjgyuppbxppvdstu")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
     */
    @JvmName("bpwarchadbasukgr")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value The ID of the automatic snapshot policy applied to the system disk.
     */
    @JvmName("hkifoeitmcurocmo")
    public suspend fun autoSnapshotPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoSnapshotPolicyId = mapped
    }

    /**
     * @param value The category of the disk:
     */
    @JvmName("aeggqlngbnvyeigd")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_essd, cloud_ssd disk. If the category of this data disk was ephemeral_ssd, please don't set this param. Default value: `true`.
     */
    @JvmName("ktakpdpiwbsmpnxa")
    public suspend fun deleteWithInstance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteWithInstance = mapped
    }

    /**
     * @param value The description of the data disk.
     */
    @JvmName("mdqunnysjliithyl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The mount point of the data disk.
     */
    @JvmName("xvhyrqeriveqjuah")
    public suspend fun device(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.device = mapped
    }

    /**
     * @param value Encrypted the data in this disk. Default value: `false`.
     */
    @JvmName("hgicerdkhskryryr")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value The KMS key ID corresponding to the Nth data disk.
     */
    @JvmName("amvhpahihlniboji")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The name of the data disk.
     */
    @JvmName("niayhrtkudjlheah")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The performance level of the ESSD used as data disk:
     * - `PL0`: A single ESSD can deliver up to 10,000 random read/write IOPS.
     * - `PL1`: A single ESSD can deliver up to 50,000 random read/write IOPS.
     * - `PL2`: A single ESSD can deliver up to 100,000 random read/write IOPS.
     * - `PL3`: A single ESSD can deliver up to 1,000,000 random read/write IOPS.
     * Default to `PL1`.
     */
    @JvmName("agpjmsgfkjkbqivs")
    public suspend fun performanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceLevel = mapped
    }

    /**
     * @param value The size of the data disk.
     * - cloud：[5, 2000]
     * - cloud_efficiency：[20, 32768]
     * - cloud_ssd：[20, 32768]
     * - cloud_essd：[20, 32768]
     * - ephemeral_ssd: [5, 800]
     */
    @JvmName("eechivryvduhvvil")
    public suspend fun size(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
     */
    @JvmName("huitgnuogmavwpei")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    internal fun build(): InstanceDataDiskArgs = InstanceDataDiskArgs(
        autoSnapshotPolicyId = autoSnapshotPolicyId,
        category = category,
        deleteWithInstance = deleteWithInstance,
        description = description,
        device = device,
        encrypted = encrypted,
        kmsKeyId = kmsKeyId,
        name = name,
        performanceLevel = performanceLevel,
        size = size ?: throw PulumiNullFieldException("size"),
        snapshotId = snapshotId,
    )
}
