@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.InstanceMaintenanceTimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endTime The end time of maintenance. The time must be on the hour at exactly 0 minute and 0 second. The `start_time` and `end_time` parameters must be specified at the same time. The `end_time` value must be 1 to 23 hours later than the `start_time` value. Specify the time in the HH:mm:ss format. The time must be in UTC+8.
 * @property startTime The start time of maintenance. The time must be on the hour at exactly 0 minute and 0 second. The `start_time` and `end_time` parameters must be specified at the same time. The `end_time` value must be 1 to 23 hours later than the `start_time` value. Specify the time in the HH:mm:ss format. The time must be in UTC+8.
 */
public data class InstanceMaintenanceTimeArgs(
    public val endTime: Output<String>? = null,
    public val startTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.InstanceMaintenanceTimeArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.InstanceMaintenanceTimeArgs =
        com.pulumi.alicloud.ecs.inputs.InstanceMaintenanceTimeArgs.builder()
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceMaintenanceTimeArgs].
 */
@PulumiTagMarker
public class InstanceMaintenanceTimeArgsBuilder internal constructor() {
    private var endTime: Output<String>? = null

    private var startTime: Output<String>? = null

    /**
     * @param value The end time of maintenance. The time must be on the hour at exactly 0 minute and 0 second. The `start_time` and `end_time` parameters must be specified at the same time. The `end_time` value must be 1 to 23 hours later than the `start_time` value. Specify the time in the HH:mm:ss format. The time must be in UTC+8.
     */
    @JvmName("uqyhpxgrbcyrmuwr")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value The start time of maintenance. The time must be on the hour at exactly 0 minute and 0 second. The `start_time` and `end_time` parameters must be specified at the same time. The `end_time` value must be 1 to 23 hours later than the `start_time` value. Specify the time in the HH:mm:ss format. The time must be in UTC+8.
     */
    @JvmName("fgbrsdgotrlwkhrb")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value The end time of maintenance. The time must be on the hour at exactly 0 minute and 0 second. The `start_time` and `end_time` parameters must be specified at the same time. The `end_time` value must be 1 to 23 hours later than the `start_time` value. Specify the time in the HH:mm:ss format. The time must be in UTC+8.
     */
    @JvmName("ucysvyhkvrhjjhke")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value The start time of maintenance. The time must be on the hour at exactly 0 minute and 0 second. The `start_time` and `end_time` parameters must be specified at the same time. The `end_time` value must be 1 to 23 hours later than the `start_time` value. Specify the time in the HH:mm:ss format. The time must be in UTC+8.
     */
    @JvmName("rjbbvhksbpltdctx")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    internal fun build(): InstanceMaintenanceTimeArgs = InstanceMaintenanceTimeArgs(
        endTime = endTime,
        startTime = startTime,
    )
}
