@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.InstanceNetworkInterfacesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property networkCardIndex The index of the network card for Secondary ENI.
 * @property networkInterfaceId The ID of the Secondary ENI.
 * @property networkInterfaceTrafficMode The communication mode of the Secondary ENI. Default value: `Standard`. Valid values:
 * - `Standard`: Uses the TCP communication mode.
 * - `HighPerformance`: Uses the remote direct memory access (RDMA) communication mode with Elastic RDMA Interface (ERI) enabled.
 * @property queuePairNumber The number of queues supported by the ERI.
 * @property securityGroupIds The ID of security group N to which to assign Secondary ENI N.
 * @property vswitchId The ID of the vSwitch to which to connect Secondary ENI N.
 */
public data class InstanceNetworkInterfacesArgs(
    public val networkCardIndex: Output<Int>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val networkInterfaceTrafficMode: Output<String>? = null,
    public val queuePairNumber: Output<Int>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.InstanceNetworkInterfacesArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.InstanceNetworkInterfacesArgs =
        com.pulumi.alicloud.ecs.inputs.InstanceNetworkInterfacesArgs.builder()
            .networkCardIndex(networkCardIndex?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .networkInterfaceTrafficMode(networkInterfaceTrafficMode?.applyValue({ args0 -> args0 }))
            .queuePairNumber(queuePairNumber?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceNetworkInterfacesArgs].
 */
@PulumiTagMarker
public class InstanceNetworkInterfacesArgsBuilder internal constructor() {
    private var networkCardIndex: Output<Int>? = null

    private var networkInterfaceId: Output<String>? = null

    private var networkInterfaceTrafficMode: Output<String>? = null

    private var queuePairNumber: Output<Int>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value The index of the network card for Secondary ENI.
     */
    @JvmName("bwuiebgsqsfqetms")
    public suspend fun networkCardIndex(`value`: Output<Int>) {
        this.networkCardIndex = value
    }

    /**
     * @param value The ID of the Secondary ENI.
     */
    @JvmName("jaxlydejfjvmqhlc")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value The communication mode of the Secondary ENI. Default value: `Standard`. Valid values:
     * - `Standard`: Uses the TCP communication mode.
     * - `HighPerformance`: Uses the remote direct memory access (RDMA) communication mode with Elastic RDMA Interface (ERI) enabled.
     */
    @JvmName("opxhnsmrkmpkxunh")
    public suspend fun networkInterfaceTrafficMode(`value`: Output<String>) {
        this.networkInterfaceTrafficMode = value
    }

    /**
     * @param value The number of queues supported by the ERI.
     */
    @JvmName("mnjycplragguexql")
    public suspend fun queuePairNumber(`value`: Output<Int>) {
        this.queuePairNumber = value
    }

    /**
     * @param value The ID of security group N to which to assign Secondary ENI N.
     */
    @JvmName("qysxpvakxkxxtfbi")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("kpngwjnrgsuiytbp")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The ID of security group N to which to assign Secondary ENI N.
     */
    @JvmName("tllwqjshvarseblh")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The ID of the vSwitch to which to connect Secondary ENI N.
     */
    @JvmName("annoyjaynghsjdau")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The index of the network card for Secondary ENI.
     */
    @JvmName("ifwedarhgubcbkvb")
    public suspend fun networkCardIndex(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkCardIndex = mapped
    }

    /**
     * @param value The ID of the Secondary ENI.
     */
    @JvmName("glikyqxcslttxokk")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value The communication mode of the Secondary ENI. Default value: `Standard`. Valid values:
     * - `Standard`: Uses the TCP communication mode.
     * - `HighPerformance`: Uses the remote direct memory access (RDMA) communication mode with Elastic RDMA Interface (ERI) enabled.
     */
    @JvmName("lupkgoaqulrarbik")
    public suspend fun networkInterfaceTrafficMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceTrafficMode = mapped
    }

    /**
     * @param value The number of queues supported by the ERI.
     */
    @JvmName("twmopuledrafxxsv")
    public suspend fun queuePairNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queuePairNumber = mapped
    }

    /**
     * @param value The ID of security group N to which to assign Secondary ENI N.
     */
    @JvmName("lmemjwffyyqmgtgd")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values The ID of security group N to which to assign Secondary ENI N.
     */
    @JvmName("bqxylucxefegxsaa")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The ID of the vSwitch to which to connect Secondary ENI N.
     */
    @JvmName("qxsucuowhndjklvd")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): InstanceNetworkInterfacesArgs = InstanceNetworkInterfacesArgs(
        networkCardIndex = networkCardIndex,
        networkInterfaceId = networkInterfaceId,
        networkInterfaceTrafficMode = networkInterfaceTrafficMode,
        queuePairNumber = queuePairNumber,
        securityGroupIds = securityGroupIds,
        vswitchId = vswitchId,
    )
}
