@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.LaunchTemplateDataDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property category The category of the disk:
 * - cloud: Basic cloud disk.
 * - cloud_efficiency: Ultra cloud disk.
 * - cloud_ssd: SSD cloud Disks.
 * - ephemeral_ssd: local SSD Disks
 * - cloud_essd: ESSD cloud Disks.
 * Default to `cloud_efficiency`.
 * @property deleteWithInstance Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_ssd and cloud_essd disk. If the category of this data disk was ephemeral_ssd, please don't set this param.
 * Default to true
 * @property description The description of the data disk.
 * @property encrypted Encrypted the data in this disk.
 * Default to false
 * @property name The name of the data disk.
 * @property performanceLevel
 * @property size The size of the data disk.
 * - cloud：[5, 2000]
 * - cloud_efficiency：[20, 32768]
 * - cloud_ssd：[20, 32768]
 * - cloud_essd：[20, 32768]
 * - ephemeral_ssd: [5, 800]
 * @property snapshotId The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
 */
public data class LaunchTemplateDataDiskArgs(
    public val category: Output<String>? = null,
    public val deleteWithInstance: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val performanceLevel: Output<String>? = null,
    public val size: Output<Int>? = null,
    public val snapshotId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.LaunchTemplateDataDiskArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.LaunchTemplateDataDiskArgs =
        com.pulumi.alicloud.ecs.inputs.LaunchTemplateDataDiskArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .deleteWithInstance(deleteWithInstance?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .performanceLevel(performanceLevel?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateDataDiskArgs].
 */
@PulumiTagMarker
public class LaunchTemplateDataDiskArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var deleteWithInstance: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var performanceLevel: Output<String>? = null

    private var size: Output<Int>? = null

    private var snapshotId: Output<String>? = null

    /**
     * @param value The category of the disk:
     * - cloud: Basic cloud disk.
     * - cloud_efficiency: Ultra cloud disk.
     * - cloud_ssd: SSD cloud Disks.
     * - ephemeral_ssd: local SSD Disks
     * - cloud_essd: ESSD cloud Disks.
     * Default to `cloud_efficiency`.
     */
    @JvmName("ubrkkxyxgexmgqxi")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_ssd and cloud_essd disk. If the category of this data disk was ephemeral_ssd, please don't set this param.
     * Default to true
     */
    @JvmName("fobcjbftsyaxxahf")
    public suspend fun deleteWithInstance(`value`: Output<Boolean>) {
        this.deleteWithInstance = value
    }

    /**
     * @param value The description of the data disk.
     */
    @JvmName("vbgcpthrpaxwkmbr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Encrypted the data in this disk.
     * Default to false
     */
    @JvmName("aqvootppclmnxfxl")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value The name of the data disk.
     */
    @JvmName("hhpgbqkovsrwgqud")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("fhsbsgabbakhhhda")
    public suspend fun performanceLevel(`value`: Output<String>) {
        this.performanceLevel = value
    }

    /**
     * @param value The size of the data disk.
     * - cloud：[5, 2000]
     * - cloud_efficiency：[20, 32768]
     * - cloud_ssd：[20, 32768]
     * - cloud_essd：[20, 32768]
     * - ephemeral_ssd: [5, 800]
     */
    @JvmName("awrcmubirapbvvms")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
     */
    @JvmName("jyecamfakdcerrtg")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value The category of the disk:
     * - cloud: Basic cloud disk.
     * - cloud_efficiency: Ultra cloud disk.
     * - cloud_ssd: SSD cloud Disks.
     * - ephemeral_ssd: local SSD Disks
     * - cloud_essd: ESSD cloud Disks.
     * Default to `cloud_efficiency`.
     */
    @JvmName("qplxsdmmudkcsojl")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_ssd and cloud_essd disk. If the category of this data disk was ephemeral_ssd, please don't set this param.
     * Default to true
     */
    @JvmName("skfahjlmsaklphjq")
    public suspend fun deleteWithInstance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteWithInstance = mapped
    }

    /**
     * @param value The description of the data disk.
     */
    @JvmName("vttvsoavuwvjmtad")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Encrypted the data in this disk.
     * Default to false
     */
    @JvmName("xbaiwbwdqwlxaaqh")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value The name of the data disk.
     */
    @JvmName("vrdhtgitbhhyfaye")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("tkodsfqlfaquhwce")
    public suspend fun performanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceLevel = mapped
    }

    /**
     * @param value The size of the data disk.
     * - cloud：[5, 2000]
     * - cloud_efficiency：[20, 32768]
     * - cloud_ssd：[20, 32768]
     * - cloud_essd：[20, 32768]
     * - ephemeral_ssd: [5, 800]
     */
    @JvmName("qwdqttvsfosvkpdb")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
     */
    @JvmName("dwaxdjhqqeuvjgxm")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    internal fun build(): LaunchTemplateDataDiskArgs = LaunchTemplateDataDiskArgs(
        category = category,
        deleteWithInstance = deleteWithInstance,
        description = description,
        encrypted = encrypted,
        name = name,
        performanceLevel = performanceLevel,
        size = size,
        snapshotId = snapshotId,
    )
}
