@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.LaunchTemplateNetworkInterfacesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description The ENI description.
 * @property name ENI name.
 * @property primaryIp The primary private IP address of the ENI.
 * @property securityGroupId The security group ID must be one in the same VPC.
 * @property vswitchId The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
 */
public data class LaunchTemplateNetworkInterfacesArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val primaryIp: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.LaunchTemplateNetworkInterfacesArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.LaunchTemplateNetworkInterfacesArgs =
        com.pulumi.alicloud.ecs.inputs.LaunchTemplateNetworkInterfacesArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .primaryIp(primaryIp?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateNetworkInterfacesArgs].
 */
@PulumiTagMarker
public class LaunchTemplateNetworkInterfacesArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var primaryIp: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value The ENI description.
     */
    @JvmName("tsdduftuloghfwyv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value ENI name.
     */
    @JvmName("opccryoetewbrwqe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The primary private IP address of the ENI.
     */
    @JvmName("rshweeovdcoltogs")
    public suspend fun primaryIp(`value`: Output<String>) {
        this.primaryIp = value
    }

    /**
     * @param value The security group ID must be one in the same VPC.
     */
    @JvmName("grwwfaojowrkhhtn")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
     */
    @JvmName("wpoginkwgrodrdpi")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The ENI description.
     */
    @JvmName("baxalgwyevjhmwst")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value ENI name.
     */
    @JvmName("dbtoewcgxnmhvbxh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The primary private IP address of the ENI.
     */
    @JvmName("utahjpbmexhleygx")
    public suspend fun primaryIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryIp = mapped
    }

    /**
     * @param value The security group ID must be one in the same VPC.
     */
    @JvmName("fydympkrsujoyvec")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
     */
    @JvmName("jixxghcfmtmcflha")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): LaunchTemplateNetworkInterfacesArgs = LaunchTemplateNetworkInterfacesArgs(
        description = description,
        name = name,
        primaryIp = primaryIp,
        securityGroupId = securityGroupId,
        vswitchId = vswitchId,
    )
}
