@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.inputs

import com.pulumi.alicloud.ecs.inputs.LaunchTemplateSystemDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property category The category of the disk:
 * - cloud: Basic cloud disk.
 * - cloud_efficiency: Ultra cloud disk.
 * - cloud_ssd: SSD cloud Disks.
 * - ephemeral_ssd: local SSD Disks
 * - cloud_essd: ESSD cloud Disks.
 * Default to `cloud_efficiency`.
 * @property deleteWithInstance Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_ssd and cloud_essd disk. If the category of this data disk was ephemeral_ssd, please don't set this param.
 * Default to true
 * @property description Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
 * @property encrypted Encrypted the data in this disk.
 * Default to false
 * @property iops
 * @property name Instance launch template name. Can contain [2, 128] characters in length. It must start with an English letter or Chinese, can contain numbers, periods (.), colons (:), underscores (_), and hyphens (-). It cannot start with "http://" or "https://".
 * @property performanceLevel
 * @property size The size of the data disk.
 * - cloud：[5, 2000]
 * - cloud_efficiency：[20, 32768]
 * - cloud_ssd：[20, 32768]
 * - cloud_essd：[20, 32768]
 * - ephemeral_ssd: [5, 800]
 */
public data class LaunchTemplateSystemDiskArgs(
    public val category: Output<String>? = null,
    public val deleteWithInstance: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val iops: Output<String>? = null,
    public val name: Output<String>? = null,
    public val performanceLevel: Output<String>? = null,
    public val size: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ecs.inputs.LaunchTemplateSystemDiskArgs> {
    override fun toJava(): com.pulumi.alicloud.ecs.inputs.LaunchTemplateSystemDiskArgs =
        com.pulumi.alicloud.ecs.inputs.LaunchTemplateSystemDiskArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .deleteWithInstance(deleteWithInstance?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .iops(iops?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .performanceLevel(performanceLevel?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateSystemDiskArgs].
 */
@PulumiTagMarker
public class LaunchTemplateSystemDiskArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var deleteWithInstance: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var iops: Output<String>? = null

    private var name: Output<String>? = null

    private var performanceLevel: Output<String>? = null

    private var size: Output<Int>? = null

    /**
     * @param value The category of the disk:
     * - cloud: Basic cloud disk.
     * - cloud_efficiency: Ultra cloud disk.
     * - cloud_ssd: SSD cloud Disks.
     * - ephemeral_ssd: local SSD Disks
     * - cloud_essd: ESSD cloud Disks.
     * Default to `cloud_efficiency`.
     */
    @JvmName("npearvsgfmirkuyu")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_ssd and cloud_essd disk. If the category of this data disk was ephemeral_ssd, please don't set this param.
     * Default to true
     */
    @JvmName("cgiktqkxthxdyvba")
    public suspend fun deleteWithInstance(`value`: Output<Boolean>) {
        this.deleteWithInstance = value
    }

    /**
     * @param value Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
     */
    @JvmName("kiwbdgpnreeidxuc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Encrypted the data in this disk.
     * Default to false
     */
    @JvmName("ptirljubhwrlukhg")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value
     */
    @JvmName("knieaarxjqeatghg")
    public suspend fun iops(`value`: Output<String>) {
        this.iops = value
    }

    /**
     * @param value Instance launch template name. Can contain [2, 128] characters in length. It must start with an English letter or Chinese, can contain numbers, periods (.), colons (:), underscores (_), and hyphens (-). It cannot start with "http://" or "https://".
     */
    @JvmName("ncdlfstkadvsbrgm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("dfsxmneiersevbjx")
    public suspend fun performanceLevel(`value`: Output<String>) {
        this.performanceLevel = value
    }

    /**
     * @param value The size of the data disk.
     * - cloud：[5, 2000]
     * - cloud_efficiency：[20, 32768]
     * - cloud_ssd：[20, 32768]
     * - cloud_essd：[20, 32768]
     * - ephemeral_ssd: [5, 800]
     */
    @JvmName("jfoaeqpppmyeibfi")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The category of the disk:
     * - cloud: Basic cloud disk.
     * - cloud_efficiency: Ultra cloud disk.
     * - cloud_ssd: SSD cloud Disks.
     * - ephemeral_ssd: local SSD Disks
     * - cloud_essd: ESSD cloud Disks.
     * Default to `cloud_efficiency`.
     */
    @JvmName("taescradlxyaiarg")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_ssd and cloud_essd disk. If the category of this data disk was ephemeral_ssd, please don't set this param.
     * Default to true
     */
    @JvmName("uwagwjnytyitrxxj")
    public suspend fun deleteWithInstance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteWithInstance = mapped
    }

    /**
     * @param value Description of instance launch template version 1. It can be [2, 256] characters in length. It cannot start with "http://" or "https://". The default value is null.
     */
    @JvmName("ibdthdsqusobuxur")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Encrypted the data in this disk.
     * Default to false
     */
    @JvmName("tunfgccwjdldxmxh")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value
     */
    @JvmName("mldguugdobmkebbf")
    public suspend fun iops(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value Instance launch template name. Can contain [2, 128] characters in length. It must start with an English letter or Chinese, can contain numbers, periods (.), colons (:), underscores (_), and hyphens (-). It cannot start with "http://" or "https://".
     */
    @JvmName("qohkguyqmrodvmaw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("eogwxuthkjceoptx")
    public suspend fun performanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceLevel = mapped
    }

    /**
     * @param value The size of the data disk.
     * - cloud：[5, 2000]
     * - cloud_efficiency：[20, 32768]
     * - cloud_ssd：[20, 32768]
     * - cloud_essd：[20, 32768]
     * - ephemeral_ssd: [5, 800]
     */
    @JvmName("rvkxehsbftxehjkn")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    internal fun build(): LaunchTemplateSystemDiskArgs = LaunchTemplateSystemDiskArgs(
        category = category,
        deleteWithInstance = deleteWithInstance,
        description = description,
        encrypted = encrypted,
        iops = iops,
        name = name,
        performanceLevel = performanceLevel,
        size = size,
    )
}
