@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceType The instance type of the Nth extended configurations of the launch template.
 * @property maxPrice The maximum price of the instance type specified in the Nth extended configurations of the launch template.
 * @property priority The priority of the instance type specified in the Nth extended configurations of the launch template. A value of 0 indicates the highest priority.
 * @property vswitchId The ID of the VSwitch in the Nth extended configurations of the launch template.
 * @property weightedCapacity The weight of the instance type specified in the Nth extended configurations of the launch template.
 */
public data class AutoProvisioningGroupLaunchTemplateConfig(
    public val instanceType: String? = null,
    public val maxPrice: String,
    public val priority: String? = null,
    public val vswitchId: String,
    public val weightedCapacity: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.AutoProvisioningGroupLaunchTemplateConfig): AutoProvisioningGroupLaunchTemplateConfig = AutoProvisioningGroupLaunchTemplateConfig(
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            maxPrice = javaType.maxPrice(),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            vswitchId = javaType.vswitchId(),
            weightedCapacity = javaType.weightedCapacity(),
        )
    }
}
