@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property slbUdpTimeout The timeout period for a UDP session between Server Load Balancer (SLB) and the dedicated host. Unit: seconds. Valid values: 15 to 310.
 * @property udpTimeout The timeout period for a UDP session between a user and an Alibaba Cloud service on the dedicated host. Unit: seconds. Valid values: 15 to 310.
 */
public data class DedicatedHostNetworkAttribute(
    public val slbUdpTimeout: Int? = null,
    public val udpTimeout: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.DedicatedHostNetworkAttribute): DedicatedHostNetworkAttribute = DedicatedHostNetworkAttribute(
            slbUdpTimeout = javaType.slbUdpTimeout().map({ args0 -> args0 }).orElse(null),
            udpTimeout = javaType.udpTimeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
