@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoSnapshotPolicyId The ID of the automatic snapshot policy applied to the system disk.
 * @property diskCategory The category of the disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
 * @property diskDescription The description of the data disk.
 * @property diskName The name of the data disk.
 * @property diskSize The size of the data disk. Unit: GiB.
 * - When `disk_category` is `cloud_efficiency`, Valid values: `20` to `32768`.
 * - When `disk_category` is `cloud_ssd`, Valid values: `20` to `32768`.
 * - When `disk_category` is `cloud_essd`, Valid values: `20` to `32768`.
 * - When `disk_category` is `cloud`, Valid values: `5` to `200`.
 * @property encrypted Encrypted the data in this disk. Default value: `false`.
 * @property kmsKeyId The KMS key ID corresponding to the data disk.
 * @property performanceLevel The performance level of the ESSD used as data disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
 * @property snapshotId The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
 */
public data class EcsInstanceSetDataDisk(
    public val autoSnapshotPolicyId: String? = null,
    public val diskCategory: String? = null,
    public val diskDescription: String? = null,
    public val diskName: String? = null,
    public val diskSize: Int,
    public val encrypted: Boolean? = null,
    public val kmsKeyId: String? = null,
    public val performanceLevel: String? = null,
    public val snapshotId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ecs.outputs.EcsInstanceSetDataDisk): EcsInstanceSetDataDisk = EcsInstanceSetDataDisk(
            autoSnapshotPolicyId = javaType.autoSnapshotPolicyId().map({ args0 -> args0 }).orElse(null),
            diskCategory = javaType.diskCategory().map({ args0 -> args0 }).orElse(null),
            diskDescription = javaType.diskDescription().map({ args0 -> args0 }).orElse(null),
            diskName = javaType.diskName().map({ args0 -> args0 }).orElse(null),
            diskSize = javaType.diskSize(),
            encrypted = javaType.encrypted().map({ args0 -> args0 }).orElse(null),
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            performanceLevel = javaType.performanceLevel().map({ args0 -> args0 }).orElse(null),
            snapshotId = javaType.snapshotId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
